/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.psi.JetElement;

public class SubroutineSinkInstruction
extends InstructionImpl {
    private final JetElement subroutine;
    private final String debugLabel;

    public SubroutineSinkInstruction(@NotNull JetElement subroutine, @NotNull String debugLabel) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineSinkInstruction", "<init>"));
        }
        if (debugLabel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineSinkInstruction", "<init>"));
        }
        this.subroutine = subroutine;
        this.debugLabel = debugLabel;
    }

    public JetElement getSubroutine() {
        return this.subroutine;
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        List<Instruction> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineSinkInstruction", "getNextInstructions"));
        }
        return list2;
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitSubroutineSink(this);
    }

    public String toString() {
        return this.debugLabel;
    }

    @Override
    protected Instruction createCopy() {
        return new SubroutineSinkInstruction(this.subroutine, this.debugLabel);
    }
}

