/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;

public final class MemberMap {
    private final Map<FunctionDescriptor, Method> methodForFunction = new HashMap<FunctionDescriptor, Method>();
    private final Map<PropertyDescriptor, Pair<Type, String>> fieldForProperty = new HashMap<PropertyDescriptor, Pair<Type, String>>();
    private final Map<PropertyDescriptor, Method> syntheticMethodForProperty = new HashMap<PropertyDescriptor, Method>();
    private final Map<CallableMemberDescriptor, String> implClassNameForCallable = new HashMap<CallableMemberDescriptor, String>();
    private final Set<PropertyDescriptor> staticFieldInOuterClass = new HashSet<PropertyDescriptor>();

    @NotNull
    public static MemberMap union(@NotNull Collection<MemberMap> maps) {
        if (maps == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "union"));
        }
        MemberMap result = new MemberMap();
        for (MemberMap map : maps) {
            for (Map.Entry<FunctionDescriptor, Method> entry : map.methodForFunction.entrySet()) {
                result.recordMethodOfDescriptor(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<CallableMemberDescriptor, Object> entry : map.fieldForProperty.entrySet()) {
                result.recordFieldOfProperty((PropertyDescriptor)entry.getKey(), (Type)((Pair)entry.getValue()).first, (String)((Pair)entry.getValue()).second);
            }
            for (Map.Entry<CallableMemberDescriptor, Object> entry : map.syntheticMethodForProperty.entrySet()) {
                result.recordSyntheticMethodOfProperty((PropertyDescriptor)entry.getKey(), (Method)entry.getValue());
            }
            for (Map.Entry<CallableMemberDescriptor, Object> entry : map.implClassNameForCallable.entrySet()) {
                result.recordImplClassNameForCallable(entry.getKey(), (String)entry.getValue());
            }
            for (PropertyDescriptor propertyDescriptor : map.staticFieldInOuterClass) {
                result.recordStaticFieldInOuterClass(propertyDescriptor);
            }
        }
        MemberMap memberMap = result;
        if (memberMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/MemberMap", "union"));
        }
        return memberMap;
    }

    public void recordMethodOfDescriptor(@NotNull FunctionDescriptor descriptor, @NotNull Method method) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "recordMethodOfDescriptor"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/MemberMap", "recordMethodOfDescriptor"));
        }
        Method old = this.methodForFunction.put(descriptor, method);
        assert (old == null) : "Duplicate method for callable member: " + descriptor + "; " + old;
    }

    public void recordFieldOfProperty(@NotNull PropertyDescriptor descriptor, @NotNull Type type, @NotNull String fieldName) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "recordFieldOfProperty"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/MemberMap", "recordFieldOfProperty"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/MemberMap", "recordFieldOfProperty"));
        }
        Pair<Type, String> old = this.fieldForProperty.put(descriptor, Pair.create(type, fieldName));
        assert (old == null) : "Duplicate field for property: " + descriptor + "; " + old;
    }

    public void recordSyntheticMethodOfProperty(@NotNull PropertyDescriptor descriptor, @NotNull Method method) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "recordSyntheticMethodOfProperty"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/MemberMap", "recordSyntheticMethodOfProperty"));
        }
        Method old = this.syntheticMethodForProperty.put(descriptor, method);
        assert (old == null) : "Duplicate synthetic method for property: " + descriptor + "; " + old;
    }

    public void recordImplClassNameForCallable(@NotNull CallableMemberDescriptor descriptor, @NotNull String name) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "recordImplClassNameForCallable"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/MemberMap", "recordImplClassNameForCallable"));
        }
        String old = this.implClassNameForCallable.put(descriptor, name);
        assert (old == null) : "Duplicate src class name for callable: " + descriptor + "; " + old;
    }

    public void recordStaticFieldInOuterClass(@NotNull PropertyDescriptor property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "recordStaticFieldInOuterClass"));
        }
        boolean added = this.staticFieldInOuterClass.add(property2);
        assert (added) : "Duplicate static field in outer class: " + property2;
    }

    @Nullable
    public Method getMethodOfDescriptor(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "getMethodOfDescriptor"));
        }
        return this.methodForFunction.get(descriptor);
    }

    @Nullable
    public Pair<Type, String> getFieldOfProperty(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "getFieldOfProperty"));
        }
        return this.fieldForProperty.get(descriptor);
    }

    @Nullable
    public Method getSyntheticMethodOfProperty(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "getSyntheticMethodOfProperty"));
        }
        return this.syntheticMethodForProperty.get(descriptor);
    }

    @Nullable
    public String getImplClassNameOfCallable(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "getImplClassNameOfCallable"));
        }
        return this.implClassNameForCallable.get(descriptor);
    }

    public boolean isStaticFieldInOuterClass(@NotNull PropertyDescriptor property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberMap", "isStaticFieldInOuterClass"));
        }
        return this.staticFieldInOuterClass.contains(property2);
    }

    public String toString() {
        return "Functions: " + this.methodForFunction.size() + ", fields: " + this.fieldForProperty.size() + ", synthetic methods: " + this.syntheticMethodForProperty.size() + ", impl class names: " + this.implClassNameForCallable.size();
    }
}

