/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.NamespaceContext;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CodegenUtil {
    private static final Random RANDOM = new Random(55L);

    private CodegenUtil() {
    }

    public static boolean isInterface(DeclarationDescriptor descriptor) {
        if (descriptor instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor).getKind();
            return kind == ClassKind.TRAIT || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isInterface(JetType type) {
        return CodegenUtil.isInterface(type.getConstructor().getDeclarationDescriptor());
    }

    public static SimpleFunctionDescriptor createInvoke(FunctionDescriptor fd) {
        int arity = fd.getValueParameters().size();
        SimpleFunctionDescriptorImpl invokeDescriptor = new SimpleFunctionDescriptorImpl(fd.getExpectedThisObject() != null ? KotlinBuiltIns.getInstance().getExtensionFunction(arity) : KotlinBuiltIns.getInstance().getFunction(arity), Collections.<AnnotationDescriptor>emptyList(), Name.identifier("invoke"), CallableMemberDescriptor.Kind.DECLARATION);
        invokeDescriptor.initialize(DescriptorUtils.getReceiverParameterType(fd.getReceiverParameter()), fd.getExpectedThisObject(), Collections.emptyList(), fd.getValueParameters(), fd.getReturnType(), Modality.FINAL, Visibilities.PUBLIC, false);
        return invokeDescriptor;
    }

    public static boolean isNonLiteralObject(JetClassOrObject myClass) {
        return myClass instanceof JetObjectDeclaration && !((JetObjectDeclaration)myClass).isObjectLiteral();
    }

    public static String createTmpVariableName(Collection<String> existingNames) {
        String prefix = "tmp";
        int i = RANDOM.nextInt(Integer.MAX_VALUE);
        String name = prefix + i;
        while (existingNames.contains(name)) {
            name = prefix + ++i;
        }
        return name;
    }

    public static JvmMethodSignature erasedInvokeSignature(FunctionDescriptor fd) {
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, false);
        boolean isExtensionFunction = fd.getReceiverParameter() != null;
        int paramCount = fd.getValueParameters().size();
        if (isExtensionFunction) {
            ++paramCount;
        }
        signatureWriter.writeParametersStart();
        for (int i = 0; i < paramCount; ++i) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            signatureWriter.writeAsmType(AsmTypeConstants.OBJECT_TYPE);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeReturnType();
        signatureWriter.writeAsmType(AsmTypeConstants.OBJECT_TYPE);
        signatureWriter.writeReturnTypeEnd();
        return signatureWriter.makeJvmMethodSignature("invoke");
    }

    public static boolean isConst(CalculatedClosure closure) {
        return closure.getCaptureThis() == null && closure.getCaptureReceiver() == null && closure.getCaptureVariables().isEmpty();
    }

    public static <T> T peekFromStack(Stack<T> stack) {
        return stack.empty() ? null : (T)stack.peek();
    }

    public static JetType getSuperClass(ClassDescriptor classDescriptor) {
        List<ClassDescriptor> superclassDescriptors = DescriptorUtils.getSuperclassDescriptors(classDescriptor);
        for (ClassDescriptor descriptor : superclassDescriptors) {
            if (descriptor.getKind() == ClassKind.TRAIT) continue;
            return descriptor.getDefaultType();
        }
        return KotlinBuiltIns.getInstance().getAnyType();
    }

    @NotNull
    public static <T extends CallableMemberDescriptor> T unwrapFakeOverride(T member) {
        while (member.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            member = member.getOverriddenDescriptors().iterator().next();
        }
        T t = member;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/CodegenUtil", "unwrapFakeOverride"));
        }
        return t;
    }

    @Nullable
    public static FunctionDescriptor getDeclaredFunctionByRawSignature(@NotNull ClassDescriptor owner, @NotNull Name name, @NotNull ClassifierDescriptor returnedClassifier, ClassifierDescriptor ... valueParameterClassifiers) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (returnedClassifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (valueParameterClassifiers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/codegen/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        Collection<FunctionDescriptor> functions = owner.getDefaultType().getMemberScope().getFunctions(name);
        for (FunctionDescriptor function : functions) {
            if (CallResolverUtil.isOrOverridesSynthesized(function) || !function.getTypeParameters().isEmpty() || !CodegenUtil.valueParameterClassesMatch(function.getValueParameters(), Arrays.asList(valueParameterClassifiers)) || !CodegenUtil.rawTypeMatches(function.getReturnType(), returnedClassifier)) continue;
            return function;
        }
        return null;
    }

    private static boolean valueParameterClassesMatch(@NotNull List<ValueParameterDescriptor> parameters, @NotNull List<ClassifierDescriptor> classifiers) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/CodegenUtil", "valueParameterClassesMatch"));
        }
        if (classifiers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/CodegenUtil", "valueParameterClassesMatch"));
        }
        if (parameters.size() != classifiers.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            ValueParameterDescriptor parameterDescriptor = parameters.get(i);
            ClassifierDescriptor classDescriptor = classifiers.get(i);
            if (CodegenUtil.rawTypeMatches(parameterDescriptor.getType(), classDescriptor)) continue;
            return false;
        }
        return true;
    }

    private static boolean rawTypeMatches(JetType type, ClassifierDescriptor classifier) {
        return type.getConstructor().getDeclarationDescriptor().getOriginal() == classifier.getOriginal();
    }

    public static boolean isCallInsideSameClassAsDeclared(CallableMemberDescriptor declarationDescriptor, CodegenContext context) {
        boolean isFakeOverride = declarationDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean isDelegate = declarationDescriptor.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        DeclarationDescriptor containingDeclaration = declarationDescriptor.getContainingDeclaration();
        containingDeclaration = containingDeclaration.getOriginal();
        return !isFakeOverride && !isDelegate && (context.hasThisDescriptor() && containingDeclaration == context.getThisDescriptor() || context.getParentContext() instanceof NamespaceContext && context.getParentContext().getContextDescriptor() == containingDeclaration) && context.getContextKind() != OwnerKind.TRAIT_IMPL;
    }

    public static boolean isCallInsideSameModuleAsDeclared(CallableMemberDescriptor declarationDescriptor, CodegenContext context) {
        if (context == CodegenContext.STATIC) {
            return true;
        }
        Object contextDescriptor = context.getContextDescriptor();
        return DescriptorUtils.isInSameModule(declarationDescriptor, contextDescriptor);
    }

    public static boolean hasAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/CodegenUtil", "hasAbstractMembers"));
        }
        return ContainerUtil.exists(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors(), new Condition<DeclarationDescriptor>(){

            @Override
            public boolean value(DeclarationDescriptor declaration) {
                if (!(declaration instanceof MemberDescriptor)) {
                    return false;
                }
                return ((MemberDescriptor)declaration).getModality() == Modality.ABSTRACT;
            }
        });
    }

    public static boolean isNullableType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/CodegenUtil", "isNullableType"));
        }
        if (type.isNullable()) {
            return true;
        }
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return TypeUtils.hasNullableSuperType(type);
        }
        return false;
    }

    public static boolean couldUseDirectAccessToProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forGetter, boolean isInsideClass, boolean isDelegated) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/CodegenUtil", "couldUseDirectAccessToProperty"));
        }
        PropertyAccessorDescriptor accessorDescriptor = forGetter ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        boolean isExtensionProperty = propertyDescriptor.getReceiverParameter() != null;
        boolean specialTypeProperty = isDelegated || isExtensionProperty || DescriptorUtils.isClassObject(propertyDescriptor.getContainingDeclaration()) || JetTypeMapper.isAccessor(propertyDescriptor);
        return isInsideClass && !specialTypeProperty && (accessorDescriptor == null || accessorDescriptor.isDefault() && (!CodegenUtil.isExternallyAccessible(propertyDescriptor) || accessorDescriptor.getModality() == Modality.FINAL));
    }

    private static boolean isExternallyAccessible(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/CodegenUtil", "isExternallyAccessible"));
        }
        return propertyDescriptor.getVisibility() != Visibilities.PRIVATE || DescriptorUtils.isClassObject(propertyDescriptor.getContainingDeclaration()) || DescriptorUtils.isTopLevelDeclaration(propertyDescriptor);
    }

    @NotNull
    public static ImplementationBodyCodegen getParentBodyCodegen(@Nullable MemberCodegen classBodyCodegen) {
        assert (classBodyCodegen != null && classBodyCodegen.getParentCodegen() instanceof ImplementationBodyCodegen) : "Class object should have appropriate parent BodyCodegen";
        ImplementationBodyCodegen implementationBodyCodegen = (ImplementationBodyCodegen)classBodyCodegen.getParentCodegen();
        if (implementationBodyCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/CodegenUtil", "getParentBodyCodegen"));
        }
        return implementationBodyCodegen;
    }

    static int getPathHashCode(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/CodegenUtil", "getPathHashCode"));
        }
        return FileUtil.toSystemDependentName(file.getVirtualFile().getPath()).hashCode();
    }

    @Nullable
    public static ClassDescriptor getExpectedThisObjectForConstructorCall(@NotNull ConstructorDescriptor descriptor, @Nullable CalculatedClosure closure) {
        ClassDescriptor expectedThisClass;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/CodegenUtil", "getExpectedThisObjectForConstructorCall"));
        }
        if (closure != null) {
            return closure.getCaptureThis();
        }
        ReceiverParameterDescriptor expectedThisObject = descriptor.getExpectedThisObject();
        if (expectedThisObject != null && !(expectedThisClass = (ClassDescriptor)expectedThisObject.getContainingDeclaration()).getKind().isObject()) {
            return expectedThisClass;
        }
        return null;
    }
}

