/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.CompilerModeProvider;
import org.jetbrains.jet.OperationModeProvider;
import org.jetbrains.jet.asJava.JavaElementFinder;
import org.jetbrains.jet.asJava.LightClassGenerationSupport;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.ClassPath;
import org.jetbrains.jet.cli.jvm.compiler.CliJetFilesProvider;
import org.jetbrains.jet.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.jet.cli.jvm.compiler.CliVirtualFileFinder;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CoreExternalAnnotationsManager;
import org.jetbrains.jet.config.CommonConfigurationKeys;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.lang.parsing.JetParserDefinition;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.JetFilesProvider;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileFinder;
import org.jetbrains.jet.plugin.JetFileType;
import org.jetbrains.jet.utils.PathUtil;

public class JetCoreEnvironment {
    private static final Object APPLICATION_LOCK = new Object();
    private static JavaCoreApplicationEnvironment ourApplicationEnvironment;
    private static int ourProjectCount;
    private final JavaCoreProjectEnvironment projectEnvironment;
    private final List<JetFile> sourceFiles;
    private final ClassPath classPath;
    private final CoreExternalAnnotationsManager annotationsManager;
    private final CompilerConfiguration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JetCoreEnvironment createForProduction(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "createForProduction"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "createForProduction"));
        }
        Disposer.register(parentDisposable, new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                Object object2 = APPLICATION_LOCK;
                synchronized (object2) {
                    if (--ourProjectCount <= 0) {
                        JetCoreEnvironment.disposeApplicationEnvironment();
                    }
                }
            }
        });
        JetCoreEnvironment environment = new JetCoreEnvironment(parentDisposable, JetCoreEnvironment.getOrCreateApplicationEnvironmentForProduction(), configuration);
        Object object2 = APPLICATION_LOCK;
        synchronized (object2) {
            ++ourProjectCount;
        }
        JetCoreEnvironment jetCoreEnvironment = environment;
        if (jetCoreEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "createForProduction"));
        }
        return jetCoreEnvironment;
    }

    @NotNull
    public static JetCoreEnvironment createForTests(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "createForTests"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "createForTests"));
        }
        JetCoreEnvironment jetCoreEnvironment = new JetCoreEnvironment(parentDisposable, JetCoreEnvironment.createApplicationEnvironment(parentDisposable), configuration);
        if (jetCoreEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "createForTests"));
        }
        return jetCoreEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static JavaCoreApplicationEnvironment getOrCreateApplicationEnvironmentForProduction() {
        Object object2 = APPLICATION_LOCK;
        // MONITORENTER : object2
        if (ourApplicationEnvironment != null) {
            JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = ourApplicationEnvironment;
            // MONITOREXIT : object2
            if (javaCoreApplicationEnvironment != null) return javaCoreApplicationEnvironment;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "getOrCreateApplicationEnvironmentForProduction"));
        }
        Disposable parentDisposable = Disposer.newDisposable();
        ourApplicationEnvironment = JetCoreEnvironment.createApplicationEnvironment(parentDisposable);
        ourProjectCount = 0;
        Disposer.register(parentDisposable, new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                Object object2 = APPLICATION_LOCK;
                synchronized (object2) {
                    ourApplicationEnvironment = null;
                }
            }
        });
        JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = ourApplicationEnvironment;
        // MONITOREXIT : object2
        if (javaCoreApplicationEnvironment != null) return javaCoreApplicationEnvironment;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "getOrCreateApplicationEnvironmentForProduction"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeApplicationEnvironment() {
        Object object2 = APPLICATION_LOCK;
        synchronized (object2) {
            if (ourApplicationEnvironment == null) {
                return;
            }
            JavaCoreApplicationEnvironment environment = ourApplicationEnvironment;
            ourApplicationEnvironment = null;
            Disposer.dispose(environment.getParentDisposable());
        }
    }

    private static JavaCoreApplicationEnvironment createApplicationEnvironment(Disposable parentDisposable) {
        JavaCoreApplicationEnvironment applicationEnvironment = new JavaCoreApplicationEnvironment(parentDisposable);
        applicationEnvironment.registerFileType(PlainTextFileType.INSTANCE, "xml");
        applicationEnvironment.registerFileType(JetFileType.INSTANCE, "kt");
        applicationEnvironment.registerFileType(JetFileType.INSTANCE, "kts");
        applicationEnvironment.registerFileType(JetFileType.INSTANCE, "ktm");
        applicationEnvironment.registerFileType(JetFileType.INSTANCE, "ktscript");
        applicationEnvironment.registerParserDefinition(new JavaParserDefinition());
        applicationEnvironment.registerParserDefinition(new JetParserDefinition());
        applicationEnvironment.getApplication().registerService(OperationModeProvider.class, new CompilerModeProvider());
        return applicationEnvironment;
    }

    private JetCoreEnvironment(@NotNull Disposable parentDisposable, @NotNull JavaCoreApplicationEnvironment applicationEnvironment, @NotNull CompilerConfiguration configuration) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "<init>"));
        }
        if (applicationEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "<init>"));
        }
        this.sourceFiles = new ArrayList<JetFile>();
        this.classPath = new ClassPath();
        this.configuration = configuration.copy();
        this.configuration.setReadOnly(true);
        this.projectEnvironment = new JavaCoreProjectEnvironment(parentDisposable, applicationEnvironment);
        MockProject project = this.projectEnvironment.getProject();
        project.registerService(JetScriptDefinitionProvider.class, new JetScriptDefinitionProvider());
        project.registerService(JetFilesProvider.class, new CliJetFilesProvider(this));
        project.registerService(CoreJavaFileManager.class, (CoreJavaFileManager)ServiceManager.getService(project, JavaFileManager.class));
        CliLightClassGenerationSupport cliLightClassGenerationSupport = new CliLightClassGenerationSupport();
        project.registerService(LightClassGenerationSupport.class, cliLightClassGenerationSupport);
        project.registerService(CliLightClassGenerationSupport.class, cliLightClassGenerationSupport);
        Extensions.getArea(project).getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new JavaElementFinder(project, cliLightClassGenerationSupport));
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClsCustomNavigationPolicy.EP_NAME, ClsCustomNavigationPolicy.class);
        this.annotationsManager = new CoreExternalAnnotationsManager(project.getComponent(PsiManager.class));
        project.registerService(ExternalAnnotationsManager.class, this.annotationsManager);
        for (Object path : configuration.getList(JVMConfigurationKeys.CLASSPATH_KEY)) {
            this.addToClasspath((File)path);
        }
        for (Object path : configuration.getList(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY)) {
            this.addExternalAnnotationsRoot((File)path);
        }
        for (Object path : configuration.getList(CommonConfigurationKeys.SOURCE_ROOTS_KEY)) {
            this.addSources((String)path);
        }
        JetScriptDefinitionProvider.getInstance(project).addScriptDefinitions(configuration.getList(CommonConfigurationKeys.SCRIPT_DEFINITIONS_KEY));
        project.registerService(VirtualFileFinder.class, new CliVirtualFileFinder(this.classPath));
    }

    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    private CoreApplicationEnvironment getMyApplicationEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.projectEnvironment.getEnvironment();
        if (coreApplicationEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "getMyApplicationEnvironment"));
        }
        return coreApplicationEnvironment;
    }

    @NotNull
    public MockApplication getApplication() {
        MockApplication mockApplication = this.getMyApplicationEnvironment().getApplication();
        if (mockApplication == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "getApplication"));
        }
        return mockApplication;
    }

    @NotNull
    public Project getProject() {
        MockProject mockProject = this.projectEnvironment.getProject();
        if (mockProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "getProject"));
        }
        return mockProject;
    }

    private void addExternalAnnotationsRoot(File path) {
        if (!path.exists()) {
            this.report(CompilerMessageSeverity.WARNING, "Annotations path entry points to a non-existent location: " + path);
            return;
        }
        this.annotationsManager.addExternalAnnotationsRoot(PathUtil.jarFileOrDirectoryToVirtualFile(path));
    }

    private void addSources(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.addSources(child);
                }
            }
        } else {
            PsiFile psiFile;
            VirtualFile fileByPath = this.getMyApplicationEnvironment().getLocalFileSystem().findFileByPath(file.getAbsolutePath());
            if (fileByPath != null && (psiFile = PsiManager.getInstance(this.getProject()).findFile(fileByPath)) instanceof JetFile) {
                this.sourceFiles.add((JetFile)psiFile);
            }
        }
    }

    private void addSources(String path) {
        if (path == null) {
            return;
        }
        VirtualFile vFile = this.getMyApplicationEnvironment().getLocalFileSystem().findFileByPath(path);
        if (vFile == null) {
            this.report(CompilerMessageSeverity.ERROR, "Source file or directory not found: " + path);
            return;
        }
        if (!vFile.isDirectory() && vFile.getFileType() != JetFileType.INSTANCE) {
            this.report(CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + path);
            return;
        }
        this.addSources(new File(path));
    }

    private void addToClasspath(File path) {
        if (path.isFile()) {
            VirtualFile jarFile = this.getMyApplicationEnvironment().getJarFileSystem().findFileByPath(path + "!/");
            if (jarFile == null) {
                this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a file that is not a JAR archive: " + path);
                return;
            }
            this.projectEnvironment.addJarToClassPath(path);
            this.classPath.add(jarFile);
        } else {
            VirtualFile root = this.getMyApplicationEnvironment().getLocalFileSystem().findFileByPath(path.getAbsolutePath());
            if (root == null) {
                this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a non-existent location: " + path);
                return;
            }
            this.projectEnvironment.addSourcesToClasspath(root);
            this.classPath.add(root);
        }
    }

    public List<JetFile> getSourceFiles() {
        return this.sourceFiles;
    }

    private void report(@NotNull CompilerMessageSeverity severity, @NotNull String message) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/compiler/JetCoreEnvironment", "report"));
        }
        MessageCollector messageCollector = this.configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector == null) {
            throw new CompileEnvironmentException(message);
        }
        messageCollector.report(severity, message, CompilerMessageLocation.NO_LOCATION);
    }

    static {
        ourProjectCount = 0;
    }
}

