/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.checkers;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.checkers.DebugInfoUtil;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;

public class CheckerTestUtil {
    public static final Comparator<Diagnostic> DIAGNOSTIC_COMPARATOR = new Comparator<Diagnostic>(){

        @Override
        public int compare(Diagnostic o1, Diagnostic o2) {
            List<TextRange> ranges1 = o1.getTextRanges();
            List<TextRange> ranges2 = o2.getTextRanges();
            if (ranges1.size() != ranges2.size()) {
                return ranges1.size() - ranges2.size();
            }
            for (int i = 0; i < ranges1.size(); ++i) {
                int endOffset2;
                int startOffset2;
                TextRange range1 = ranges1.get(i);
                TextRange range2 = ranges2.get(i);
                int startOffset1 = range1.getStartOffset();
                if (startOffset1 != (startOffset2 = range2.getStartOffset())) {
                    return startOffset1 - range2.getStartOffset();
                }
                int endOffset1 = range1.getEndOffset();
                if (endOffset1 == (endOffset2 = range2.getEndOffset())) continue;
                return endOffset2 - endOffset1;
            }
            return 0;
        }
    };
    private static final Pattern RANGE_START_OR_END_PATTERN = Pattern.compile("(<!\\w+(,\\s*\\w+)*!>)|(<!>)");
    private static final Pattern INDIVIDUAL_DIAGNOSTIC_PATTERN = Pattern.compile("\\w+");

    public static List<Diagnostic> getDiagnosticsIncludingSyntaxErrors(BindingContext bindingContext, final PsiElement root) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        diagnostics.addAll(Collections2.filter(bindingContext.getDiagnostics().all(), new Predicate<Diagnostic>(){

            @Override
            public boolean apply(Diagnostic diagnostic) {
                return PsiTreeUtil.isAncestor(root, diagnostic.getPsiElement(), false);
            }
        }));
        for (PsiErrorElement errorElement : AnalyzingUtils.getSyntaxErrorRanges(root)) {
            diagnostics.add(new SyntaxErrorDiagnostic(errorElement));
        }
        List<Diagnostic> debugAnnotations = CheckerTestUtil.getDebugInfoDiagnostics(root, bindingContext);
        diagnostics.addAll(debugAnnotations);
        return diagnostics;
    }

    public static List<Diagnostic> getDebugInfoDiagnostics(@NotNull PsiElement root, @NotNull BindingContext bindingContext) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        final ArrayList<Diagnostic> debugAnnotations = Lists.newArrayList();
        DebugInfoUtil.markDebugAnnotations(root, bindingContext, new DebugInfoUtil.DebugInfoReporter(){

            @Override
            public void reportElementWithErrorType(@NotNull JetReferenceExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/checkers/CheckerTestUtil$3", "reportElementWithErrorType"));
                }
                this.newDiagnostic(expression, DebugInfoDiagnosticFactory.ELEMENT_WITH_ERROR_TYPE);
            }

            @Override
            public void reportMissingUnresolved(@NotNull JetReferenceExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/checkers/CheckerTestUtil$3", "reportMissingUnresolved"));
                }
                this.newDiagnostic(expression, DebugInfoDiagnosticFactory.MISSING_UNRESOLVED);
            }

            @Override
            public void reportUnresolvedWithTarget(@NotNull JetReferenceExpression expression, @NotNull String target) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/checkers/CheckerTestUtil$3", "reportUnresolvedWithTarget"));
                }
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/checkers/CheckerTestUtil$3", "reportUnresolvedWithTarget"));
                }
                this.newDiagnostic(expression, DebugInfoDiagnosticFactory.UNRESOLVED_WITH_TARGET);
            }

            private void newDiagnostic(JetReferenceExpression expression, DebugInfoDiagnosticFactory factory) {
                debugAnnotations.add(new DebugInfoDiagnostic(expression, factory));
            }
        });
        return debugAnnotations;
    }

    public static void diagnosticsDiff(List<DiagnosedRange> expected, Collection<Diagnostic> actual, DiagnosticDiffCallbacks callbacks) {
        CheckerTestUtil.assertSameFile(actual);
        Iterator<DiagnosedRange> expectedDiagnostics = expected.iterator();
        List<DiagnosticDescriptor> sortedDiagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(actual);
        Iterator<DiagnosticDescriptor> actualDiagnostics = sortedDiagnosticDescriptors.iterator();
        DiagnosedRange currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
        DiagnosticDescriptor currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        while (currentExpected != null || currentActual != null) {
            if (currentExpected != null) {
                Multiset<String> expectedDiagnosticTypes;
                if (currentActual == null) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                int expectedStart = currentExpected.getStart();
                int actualStart = currentActual.getStart();
                int expectedEnd = currentExpected.getEnd();
                int actualEnd = currentActual.getEnd();
                if (expectedStart < actualStart) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedStart > actualStart) {
                    CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                if (expectedEnd > actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedEnd < actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                assert (expectedStart == actualStart && expectedEnd == actualEnd);
                Multiset<String> actualDiagnosticTypes = currentActual.getDiagnosticTypeStrings();
                if (!actualDiagnosticTypes.equals(expectedDiagnosticTypes = currentExpected.getDiagnostics())) {
                    HashMultiset<String> expectedCopy = HashMultiset.create(expectedDiagnosticTypes);
                    expectedCopy.removeAll(actualDiagnosticTypes);
                    HashMultiset<String> actualCopy = HashMultiset.create(actualDiagnosticTypes);
                    actualCopy.removeAll(expectedDiagnosticTypes);
                    for (String type : expectedCopy) {
                        callbacks.missingDiagnostic(type, expectedStart, expectedEnd);
                    }
                    for (String type : actualCopy) {
                        callbacks.unexpectedDiagnostic(type, actualStart, actualEnd);
                    }
                }
                currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                continue;
            }
            if (currentActual == null) break;
            CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
            currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        }
    }

    private static void assertSameFile(Collection<Diagnostic> actual) {
        if (actual.isEmpty()) {
            return;
        }
        PsiFile file = actual.iterator().next().getPsiElement().getContainingFile();
        for (Diagnostic diagnostic : actual) {
            assert (diagnostic.getPsiFile().equals(file)) : "All diagnostics should come from the same file: " + diagnostic.getPsiFile() + ", " + file;
        }
    }

    private static void unexpectedDiagnostics(List<Diagnostic> actual, DiagnosticDiffCallbacks callbacks) {
        for (Diagnostic diagnostic : actual) {
            List<TextRange> textRanges = diagnostic.getTextRanges();
            for (TextRange textRange : textRanges) {
                callbacks.unexpectedDiagnostic(diagnostic.getFactory().getName(), textRange.getStartOffset(), textRange.getEndOffset());
            }
        }
    }

    private static void missingDiagnostics(DiagnosticDiffCallbacks callbacks, DiagnosedRange currentExpected) {
        for (String type : currentExpected.getDiagnostics()) {
            callbacks.missingDiagnostic(type, currentExpected.getStart(), currentExpected.getEnd());
        }
    }

    private static <T> T safeAdvance(Iterator<T> iterator2) {
        return iterator2.hasNext() ? (T)iterator2.next() : null;
    }

    public static String parseDiagnosedRanges(String text, List<DiagnosedRange> result) {
        Matcher matcher = RANGE_START_OR_END_PATTERN.matcher(text);
        Stack<DiagnosedRange> opened = new Stack<DiagnosedRange>();
        int offsetCompensation = 0;
        while (matcher.find()) {
            int effectiveOffset = matcher.start() - offsetCompensation;
            String matchedText = matcher.group();
            if ("<!>".equals(matchedText)) {
                ((DiagnosedRange)opened.pop()).setEnd(effectiveOffset);
            } else {
                Matcher diagnosticTypeMatcher = INDIVIDUAL_DIAGNOSTIC_PATTERN.matcher(matchedText);
                DiagnosedRange range = new DiagnosedRange(effectiveOffset);
                while (diagnosticTypeMatcher.find()) {
                    range.addDiagnostic(diagnosticTypeMatcher.group());
                }
                opened.push(range);
                result.add(range);
            }
            offsetCompensation += matchedText.length();
        }
        assert (opened.isEmpty()) : "Stack is not empty";
        matcher.reset();
        return matcher.replaceAll("");
    }

    public static StringBuffer addDiagnosticMarkersToText(final @NotNull PsiFile psiFile, Collection<Diagnostic> diagnostics) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        StringBuffer result = new StringBuffer();
        String text = psiFile.getText();
        if (!(diagnostics = Collections2.filter(diagnostics, new Predicate<Diagnostic>(){

            @Override
            public boolean apply(Diagnostic diagnostic) {
                return psiFile.equals(diagnostic.getPsiFile());
            }
        })).isEmpty()) {
            List<DiagnosticDescriptor> diagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(diagnostics);
            Stack<DiagnosticDescriptor> opened = new Stack<DiagnosticDescriptor>();
            ListIterator<DiagnosticDescriptor> iterator2 = diagnosticDescriptors.listIterator();
            DiagnosticDescriptor currentDescriptor = iterator2.next();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                while (!opened.isEmpty() && i == ((DiagnosticDescriptor)opened.peek()).end) {
                    CheckerTestUtil.closeDiagnosticString(result);
                    opened.pop();
                }
                while (currentDescriptor != null && i == currentDescriptor.start) {
                    CheckerTestUtil.openDiagnosticsString(result, currentDescriptor);
                    if (currentDescriptor.getEnd() == i) {
                        CheckerTestUtil.closeDiagnosticString(result);
                    } else {
                        opened.push(currentDescriptor);
                    }
                    if (iterator2.hasNext()) {
                        currentDescriptor = iterator2.next();
                        continue;
                    }
                    currentDescriptor = null;
                }
                result.append(c);
            }
            if (currentDescriptor != null) {
                assert (currentDescriptor.start == text.length());
                assert (currentDescriptor.end == text.length());
                CheckerTestUtil.openDiagnosticsString(result, currentDescriptor);
                opened.push(currentDescriptor);
            }
            while (!opened.isEmpty() && text.length() == ((DiagnosticDescriptor)opened.peek()).end) {
                CheckerTestUtil.closeDiagnosticString(result);
                opened.pop();
            }
            assert (opened.isEmpty()) : "Stack is not empty: " + opened;
        } else {
            result.append(text);
        }
        return result;
    }

    private static void openDiagnosticsString(StringBuffer result, DiagnosticDescriptor currentDescriptor) {
        result.append("<!");
        Iterator iterator2 = currentDescriptor.diagnostics.iterator();
        while (iterator2.hasNext()) {
            Diagnostic diagnostic = (Diagnostic)iterator2.next();
            result.append(diagnostic.getFactory().getName());
            if (!iterator2.hasNext()) continue;
            result.append(", ");
        }
        result.append("!>");
    }

    private static void closeDiagnosticString(StringBuffer result) {
        result.append("<!>");
    }

    private static List<DiagnosticDescriptor> getSortedDiagnosticDescriptors(Collection<Diagnostic> diagnostics) {
        ArrayList<Diagnostic> list2 = Lists.newArrayList(diagnostics);
        Collections.sort(list2, DIAGNOSTIC_COMPARATOR);
        ArrayList<DiagnosticDescriptor> diagnosticDescriptors = Lists.newArrayList();
        DiagnosticDescriptor currentDiagnosticDescriptor = null;
        for (Diagnostic diagnostic : list2) {
            List<TextRange> textRanges = diagnostic.getTextRanges();
            if (!diagnostic.isValid()) continue;
            TextRange textRange = textRanges.get(0);
            if (currentDiagnosticDescriptor != null && currentDiagnosticDescriptor.equalRange(textRange)) {
                currentDiagnosticDescriptor.diagnostics.add(diagnostic);
                continue;
            }
            currentDiagnosticDescriptor = new DiagnosticDescriptor(textRange.getStartOffset(), textRange.getEndOffset(), diagnostic);
            diagnosticDescriptors.add(currentDiagnosticDescriptor);
        }
        return diagnosticDescriptors;
    }

    public static class DiagnosedRange {
        private final int start;
        private int end;
        private final Multiset<String> diagnostics = HashMultiset.create();
        private PsiFile file;

        private DiagnosedRange(int start) {
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public Multiset<String> getDiagnostics() {
            return this.diagnostics;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void addDiagnostic(String diagnostic) {
            this.diagnostics.add(diagnostic);
        }

        public void setFile(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/checkers/CheckerTestUtil$DiagnosedRange", "setFile"));
            }
            this.file = file;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.file;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/checkers/CheckerTestUtil$DiagnosedRange", "getFile"));
            }
            return psiFile;
        }
    }

    private static class DiagnosticDescriptor {
        private final int start;
        private final int end;
        private final List<Diagnostic> diagnostics = Lists.newArrayList();

        DiagnosticDescriptor(int start, int end, Diagnostic diagnostic) {
            this.start = start;
            this.end = end;
            this.diagnostics.add(diagnostic);
        }

        public boolean equalRange(TextRange textRange) {
            return this.start == textRange.getStartOffset() && this.end == textRange.getEndOffset();
        }

        public Multiset<String> getDiagnosticTypeStrings() {
            HashMultiset<String> actualDiagnosticTypes = HashMultiset.create();
            for (Diagnostic diagnostic : this.diagnostics) {
                actualDiagnosticTypes.add(diagnostic.getFactory().getName());
            }
            return actualDiagnosticTypes;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<Diagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        public TextRange getTextRange() {
            return new TextRange(this.start, this.end);
        }
    }

    public static class DebugInfoDiagnostic
    extends AbstractDiagnosticForTests {
        public DebugInfoDiagnostic(@NotNull JetReferenceExpression reference, @NotNull DebugInfoDiagnosticFactory factory) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/checkers/CheckerTestUtil$DebugInfoDiagnostic", "<init>"));
            }
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/checkers/CheckerTestUtil$DebugInfoDiagnostic", "<init>"));
            }
            super(reference, factory);
        }
    }

    public static class DebugInfoDiagnosticFactory
    extends DiagnosticFactory {
        public static final DebugInfoDiagnosticFactory ELEMENT_WITH_ERROR_TYPE = new DebugInfoDiagnosticFactory("ELEMENT_WITH_ERROR_TYPE");
        public static final DebugInfoDiagnosticFactory UNRESOLVED_WITH_TARGET = new DebugInfoDiagnosticFactory("UNRESOLVED_WITH_TARGET");
        public static final DebugInfoDiagnosticFactory MISSING_UNRESOLVED = new DebugInfoDiagnosticFactory("MISSING_UNRESOLVED");
        private final String name;

        private DebugInfoDiagnosticFactory(String name) {
            super(Severity.ERROR);
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = "DEBUG_INFO_" + this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/checkers/CheckerTestUtil$DebugInfoDiagnosticFactory", "getName"));
            }
            return string;
        }
    }

    public static class SyntaxErrorDiagnostic
    extends AbstractDiagnosticForTests {
        public SyntaxErrorDiagnostic(@NotNull PsiErrorElement errorElement) {
            if (errorElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/checkers/CheckerTestUtil$SyntaxErrorDiagnostic", "<init>"));
            }
            super(errorElement, SyntaxErrorDiagnosticFactory.INSTANCE);
        }
    }

    public static class SyntaxErrorDiagnosticFactory
    extends DiagnosticFactory {
        public static final SyntaxErrorDiagnosticFactory INSTANCE = new SyntaxErrorDiagnosticFactory();

        private SyntaxErrorDiagnosticFactory() {
            super(Severity.ERROR);
        }

        @Override
        @NotNull
        public String getName() {
            if ("SYNTAX" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/checkers/CheckerTestUtil$SyntaxErrorDiagnosticFactory", "getName"));
            }
            return "SYNTAX";
        }
    }

    public static class AbstractDiagnosticForTests
    implements Diagnostic {
        private final PsiElement element;
        private final DiagnosticFactory factory;

        public AbstractDiagnosticForTests(@NotNull PsiElement element, @NotNull DiagnosticFactory factory) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "<init>"));
            }
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "<init>"));
            }
            this.element = element;
            this.factory = factory;
        }

        @Override
        @NotNull
        public DiagnosticFactory getFactory() {
            DiagnosticFactory diagnosticFactory = this.factory;
            if (diagnosticFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getFactory"));
            }
            return diagnosticFactory;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            Severity severity = Severity.ERROR;
            if (severity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getSeverity"));
            }
            return severity;
        }

        @Override
        @NotNull
        public PsiElement getPsiElement() {
            PsiElement psiElement = this.element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getPsiElement"));
            }
            return psiElement;
        }

        @Override
        @NotNull
        public List<TextRange> getTextRanges() {
            List<TextRange> list2 = Collections.singletonList(this.element.getTextRange());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getTextRanges"));
            }
            return list2;
        }

        @Override
        @NotNull
        public PsiFile getPsiFile() {
            PsiFile psiFile = this.element.getContainingFile();
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getPsiFile"));
            }
            return psiFile;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    public static interface DiagnosticDiffCallbacks {
        public void missingDiagnostic(String var1, int var2, int var3);

        public void unexpectedDiagnostic(String var1, int var2, int var3);
    }
}

