/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InferenceVariable {
    private boolean myCaptured;
    private Map<InferenceBound, List<PsiType>> myBounds = new HashMap<InferenceBound, List<PsiType>>();
    private PsiTypeParameter myParameter;
    private PsiType myInstantiation = PsiType.NULL;

    public PsiTypeParameter getParameter() {
        return this.myParameter;
    }

    public InferenceVariable(PsiTypeParameter parameter) {
        this.myParameter = parameter;
    }

    public PsiType getInstantiation() {
        return this.myInstantiation;
    }

    public void setInstantiation(PsiType instantiation) {
        this.myInstantiation = instantiation;
    }

    public void ignoreInstantiation() {
        this.myInstantiation = PsiType.NULL;
    }

    public boolean isCaptured() {
        return this.myCaptured;
    }

    public void setCaptured(boolean captured) {
        this.myCaptured = captured;
    }

    public boolean addBound(PsiType classType, InferenceBound inferenceBound) {
        int idx;
        List<PsiType> list2 = this.myBounds.get((Object)inferenceBound);
        if (list2 == null) {
            list2 = new ArrayList<PsiType>();
            this.myBounds.put(inferenceBound, list2);
        }
        if ((idx = list2.indexOf(classType)) < 0 || inferenceBound == InferenceBound.EQ && classType instanceof PsiCapturedWildcardType && list2.get(idx) != classType) {
            list2.add(classType);
            return true;
        }
        return false;
    }

    public List<PsiType> getBounds(InferenceBound inferenceBound) {
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        return bounds != null ? new ArrayList<PsiType>(bounds) : Collections.emptyList();
    }

    public Set<InferenceVariable> getDependencies(InferenceSession session) {
        HashSet<InferenceVariable> dependencies = new HashSet<InferenceVariable>();
        for (InferenceBound inferenceBound : InferenceBound.values()) {
            for (PsiType bound : this.getBounds(inferenceBound)) {
                session.collectDependencies(bound, dependencies, true);
            }
        }
        return dependencies;
    }
}

