/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.SubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import java.util.List;

public class InferenceIncorporationPhase {
    private InferenceSession mySession;

    public InferenceIncorporationPhase(InferenceSession session) {
        this.mySession = session;
    }

    public void incorporate() {
        for (InferenceVariable inferenceVariable : this.mySession.getInferenceVariables()) {
            if (inferenceVariable.getInstantiation() != PsiType.NULL || inferenceVariable.isCaptured()) continue;
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
            List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            this.eqEq(eqBounds);
            this.upperLower(upperBounds, lowerBounds);
            this.upDown(eqBounds, upperBounds);
            this.upDown(lowerBounds, eqBounds);
        }
    }

    boolean isFullyIncorporated() {
        boolean needFurtherIncorporation = false;
        for (InferenceVariable inferenceVariable : this.mySession.getInferenceVariables()) {
            if (inferenceVariable.getInstantiation() != PsiType.NULL) continue;
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
            List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            needFurtherIncorporation |= this.crossVariables(inferenceVariable, upperBounds, lowerBounds, InferenceBound.LOWER);
            needFurtherIncorporation |= this.crossVariables(inferenceVariable, lowerBounds, upperBounds, InferenceBound.UPPER);
            needFurtherIncorporation |= this.eqCrossVariables(inferenceVariable, eqBounds);
        }
        return !needFurtherIncorporation;
    }

    private boolean eqCrossVariables(InferenceVariable inferenceVariable, List<PsiType> eqBounds) {
        boolean needFurtherIncorporation = false;
        for (PsiType eqBound : eqBounds) {
            InferenceVariable inferenceVar = this.mySession.getInferenceVariable(eqBound);
            if (inferenceVar == null || inferenceVar.isCaptured()) continue;
            for (InferenceBound inferenceBound : InferenceBound.values()) {
                for (PsiType bound : inferenceVariable.getBounds(inferenceBound)) {
                    if (this.mySession.getInferenceVariable(bound) == inferenceVar) continue;
                    needFurtherIncorporation |= inferenceVar.addBound(bound, inferenceBound);
                }
                for (PsiType bound : inferenceVar.getBounds(inferenceBound)) {
                    if (this.mySession.getInferenceVariable(bound) == inferenceVariable) continue;
                    needFurtherIncorporation |= inferenceVariable.addBound(bound, inferenceBound);
                }
            }
        }
        return needFurtherIncorporation;
    }

    private boolean crossVariables(InferenceVariable inferenceVariable, List<PsiType> upperBounds, List<PsiType> lowerBounds, InferenceBound inferenceBound) {
        InferenceBound oppositeBound = inferenceBound == InferenceBound.LOWER ? InferenceBound.UPPER : InferenceBound.LOWER;
        boolean result = false;
        for (PsiType upperBound : upperBounds) {
            InferenceVariable inferenceVar = this.mySession.getInferenceVariable(upperBound);
            if (inferenceVar == null || inferenceVar.isCaptured()) continue;
            for (PsiType lowerBound : lowerBounds) {
                result |= inferenceVar.addBound(lowerBound, inferenceBound);
            }
            for (PsiType varUpperBound : inferenceVar.getBounds(oppositeBound)) {
                result |= inferenceVariable.addBound(varUpperBound, oppositeBound);
            }
        }
        return result;
    }

    private void upDown(List<PsiType> eqBounds, List<PsiType> upperBounds) {
        for (PsiType upperBound : upperBounds) {
            boolean properType = this.mySession.isProperType(upperBound);
            for (PsiType eqBound : eqBounds) {
                if (properType && this.mySession.isProperType(eqBound) || upperBound.equals(eqBound)) continue;
                this.addConstraint(new SubtypingConstraint(upperBound, eqBound, true));
            }
        }
    }

    private void upperLower(List<PsiType> upperBounds, List<PsiType> lowerBounds) {
        for (PsiType upperBound : upperBounds) {
            boolean properType = this.mySession.isProperType(upperBound);
            for (PsiType lowerBound : lowerBounds) {
                if (properType && this.mySession.isProperType(lowerBound) || upperBound.equals(lowerBound)) continue;
                this.addConstraint(new SubtypingConstraint(upperBound, lowerBound, true));
            }
        }
    }

    private void eqEq(List<PsiType> eqBounds) {
        for (int i = 0; i < eqBounds.size(); ++i) {
            PsiType sBound = eqBounds.get(i);
            if (sBound == null) continue;
            for (int j = i + 1; j < eqBounds.size(); ++j) {
                PsiType tBound = eqBounds.get(j);
                if (tBound == null) continue;
                this.addConstraint(new TypeEqualityConstraint(tBound, sBound));
            }
        }
    }

    private void addConstraint(ConstraintFormula constraint) {
        this.mySession.addConstraint(constraint);
    }
}

