/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.MultiDeclarationTranslator;
import org.jetbrains.k2js.translate.expression.foreach.ArrayForTranslator;
import org.jetbrains.k2js.translate.expression.foreach.IteratorForTranslator;
import org.jetbrains.k2js.translate.expression.foreach.RangeForTranslator;
import org.jetbrains.k2js.translate.expression.foreach.RangeLiteralForTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public abstract class ForTranslator
extends AbstractTranslator {
    @NotNull
    protected final JetForExpression expression;
    @NotNull
    protected final JsName parameterName;
    @Nullable
    protected final JetMultiDeclaration multiParameter;

    @NotNull
    public static JsStatement translate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "translate"));
        }
        if (RangeLiteralForTranslator.isApplicable(expression, context)) {
            JsStatement jsStatement = RangeLiteralForTranslator.doTranslate(expression, context);
            if (jsStatement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "translate"));
            }
            return jsStatement;
        }
        if (RangeForTranslator.isApplicable(expression, context)) {
            JsStatement jsStatement = RangeForTranslator.doTranslate(expression, context);
            if (jsStatement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "translate"));
            }
            return jsStatement;
        }
        if (ArrayForTranslator.isApplicable(expression, context)) {
            JsStatement jsStatement = ArrayForTranslator.doTranslate(expression, context);
            if (jsStatement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "translate"));
            }
            return jsStatement;
        }
        JsStatement jsStatement = IteratorForTranslator.doTranslate(expression, context);
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "translate"));
        }
        return jsStatement;
    }

    protected ForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "<init>"));
        }
        super(context);
        this.expression = forExpression;
        this.multiParameter = forExpression.getMultiParameter();
        this.parameterName = this.declareParameter();
    }

    @NotNull
    private JsName declareParameter() {
        JetParameter loopParameter = PsiUtils.getLoopParameter(this.expression);
        if (loopParameter != null) {
            JsName jsName = this.context().getNameForElement(loopParameter);
            if (jsName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "declareParameter"));
            }
            return jsName;
        }
        assert (this.parameterIsMultiDeclaration()) : "If loopParameter is null, multi parameter must be not null";
        JsName jsName = this.context().scope().declareTemporary();
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "declareParameter"));
        }
        return jsName;
    }

    private boolean parameterIsMultiDeclaration() {
        return this.multiParameter != null;
    }

    @NotNull
    private JsStatement makeCurrentVarInit(@Nullable JsExpression itemValue) {
        if (this.multiParameter == null) {
            JsVars jsVars = JsAstUtils.newVar(this.parameterName, itemValue);
            if (jsVars == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "makeCurrentVarInit"));
            }
            return jsVars;
        }
        JsVars jsVars = MultiDeclarationTranslator.translate(this.multiParameter, this.parameterName, itemValue, this.context());
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "makeCurrentVarInit"));
        }
        return jsVars;
    }

    @NotNull
    protected JsStatement translateBody(@Nullable JsExpression itemValue) {
        JsStatement realBody = Translation.translateAsStatement(PsiUtils.getLoopBody(this.expression), this.context());
        if (itemValue == null && !this.parameterIsMultiDeclaration()) {
            JsStatement jsStatement = realBody;
            if (jsStatement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "translateBody"));
            }
            return jsStatement;
        }
        JsStatement currentVarInit = this.makeCurrentVarInit(itemValue);
        if (realBody instanceof JsBlock) {
            JsBlock block = (JsBlock)realBody;
            block.getStatements().add(0, currentVarInit);
            JsBlock jsBlock = block;
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "translateBody"));
            }
            return jsBlock;
        }
        JsBlock jsBlock = new JsBlock(currentVarInit, realBody);
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/ForTranslator", "translateBody"));
        }
        return jsBlock;
    }
}

