/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.FunctionTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class PropertyTranslator
extends AbstractTranslator {
    @NotNull
    private final PropertyDescriptor descriptor;
    @Nullable
    private final JetProperty declaration;

    public static void translateAccessors(@NotNull PropertyDescriptor descriptor, @NotNull List<JsPropertyInitializer> result, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "translateAccessors"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "translateAccessors"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "translateAccessors"));
        }
        PropertyTranslator.translateAccessors(descriptor, null, result, context);
    }

    public static void translateAccessors(@NotNull PropertyDescriptor descriptor, @Nullable JetProperty declaration, @NotNull List<JsPropertyInitializer> result, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "translateAccessors"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "translateAccessors"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "translateAccessors"));
        }
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor)) {
            new PropertyTranslator(descriptor, declaration, context).translate(result);
        }
    }

    private PropertyTranslator(@NotNull PropertyDescriptor descriptor, @Nullable JetProperty declaration, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "<init>"));
        }
        super(context);
        this.descriptor = descriptor;
        this.declaration = declaration;
    }

    private void translate(@NotNull List<JsPropertyInitializer> result) {
        List<JsPropertyInitializer> to;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "translate"));
        }
        if (!JsDescriptorUtils.isExtension(this.descriptor)) {
            to = new SmartList<JsPropertyInitializer>();
            result.add(new JsPropertyInitializer(this.context().getNameForDescriptor(this.descriptor).makeRef(), new JsObjectLiteral(to, true)));
        } else {
            to = result;
        }
        to.add(this.generateGetter());
        if (this.descriptor.isVar()) {
            to.add(this.generateSetter());
        }
    }

    private JsPropertyInitializer generateGetter() {
        if (this.hasCustomGetter()) {
            return this.translateCustomAccessor(this.getCustomGetterDeclaration());
        }
        return this.generateDefaultGetter();
    }

    private JsPropertyInitializer generateSetter() {
        if (this.hasCustomSetter()) {
            return this.translateCustomAccessor(this.getCustomSetterDeclaration());
        }
        return this.generateDefaultSetter();
    }

    private boolean hasCustomGetter() {
        return this.declaration != null && this.declaration.getGetter() != null && this.getCustomGetterDeclaration().getBodyExpression() != null;
    }

    private boolean hasCustomSetter() {
        return this.declaration != null && this.declaration.getSetter() != null && this.getCustomSetterDeclaration().getBodyExpression() != null;
    }

    @NotNull
    private JetPropertyAccessor getCustomGetterDeclaration() {
        assert (this.declaration != null);
        JetPropertyAccessor getterDeclaration = this.declaration.getGetter();
        assert (getterDeclaration != null);
        JetPropertyAccessor jetPropertyAccessor = getterDeclaration;
        if (jetPropertyAccessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "getCustomGetterDeclaration"));
        }
        return jetPropertyAccessor;
    }

    @NotNull
    private JetPropertyAccessor getCustomSetterDeclaration() {
        assert (this.declaration != null);
        JetPropertyAccessor setter = this.declaration.getSetter();
        assert (setter != null);
        JetPropertyAccessor jetPropertyAccessor = setter;
        if (jetPropertyAccessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "getCustomSetterDeclaration"));
        }
        return jetPropertyAccessor;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultGetter() {
        PropertyGetterDescriptor getterDescriptor = this.descriptor.getGetter();
        assert (getterDescriptor != null) : "Getter descriptor should not be null";
        JsPropertyInitializer jsPropertyInitializer = this.generateDefaultAccessor(getterDescriptor, this.generateDefaultGetterFunction(getterDescriptor));
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "generateDefaultGetter"));
        }
        return jsPropertyInitializer;
    }

    private JsExpression createPropertyMetadata() {
        JsNameRef propertyMetadataRef = this.context().namer().propertyMetadataRef();
        JsStringLiteral argument = this.context().program().getStringLiteral(this.getPropertyName());
        return new JsNew(propertyMetadataRef, Collections.singletonList(argument));
    }

    private JsExpression getDelegateCall(ResolvedCall<FunctionDescriptor> call, List<JsExpression> args) {
        return CallBuilder.build(this.context()).receiver(Namer.getDelegateNameRef(this.getPropertyName())).args(args).resolvedCall(call).type(CallType.NORMAL).translate();
    }

    private String getPropertyName() {
        return this.descriptor.getName().asString();
    }

    @NotNull
    private JsFunction generateDefaultGetterFunction(@NotNull PropertyGetterDescriptor getterDescriptor) {
        if (getterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "generateDefaultGetterFunction"));
        }
        ResolvedCall<FunctionDescriptor> delegatedCall = this.bindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getterDescriptor);
        JsExpression value = delegatedCall != null ? this.getDelegateCall(delegatedCall, this.getDelegateCallArgs(null)) : TranslationUtils.backingFieldReference(this.context(), this.descriptor);
        JsFunction jsFunction = TranslationUtils.simpleReturnFunction(this.context().getScopeForDescriptor(getterDescriptor.getContainingDeclaration()), value);
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "generateDefaultGetterFunction"));
        }
        return jsFunction;
    }

    @NotNull
    private List<JsExpression> getDelegateCallArgs(@Nullable JsExpression valueExpression) {
        ArrayList<JsExpression> args = new ArrayList<JsExpression>();
        args.add(JsLiteral.THIS);
        args.add(this.createPropertyMetadata());
        if (valueExpression != null) {
            args.add(valueExpression);
        }
        ArrayList<JsExpression> arrayList = args;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "getDelegateCallArgs"));
        }
        return arrayList;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultSetter() {
        PropertySetterDescriptor setterDescriptor = this.descriptor.getSetter();
        assert (setterDescriptor != null) : "Setter descriptor should not be null";
        JsPropertyInitializer jsPropertyInitializer = this.generateDefaultAccessor(setterDescriptor, this.generateDefaultSetterFunction(setterDescriptor));
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "generateDefaultSetter"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    private JsFunction generateDefaultSetterFunction(@NotNull PropertySetterDescriptor setterDescriptor) {
        if (setterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "generateDefaultSetterFunction"));
        }
        JsFunction fun = new JsFunction(this.context().getScopeForDescriptor(setterDescriptor.getContainingDeclaration()));
        JsParameter defaultParameter = new JsParameter(this.propertyAccessContext(setterDescriptor).scope().declareTemporary());
        fun.getParameters().add(defaultParameter);
        ResolvedCall<FunctionDescriptor> delegatedCall = this.bindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, setterDescriptor);
        JsNameRef defaultParameterRef = defaultParameter.getName().makeRef();
        JsExpression setExpression = delegatedCall != null ? this.getDelegateCall(delegatedCall, this.getDelegateCallArgs(defaultParameterRef)) : TranslationUtils.assignmentToBackingField(this.context(), this.descriptor, defaultParameterRef);
        fun.setBody(new JsBlock(setExpression.makeStmt()));
        JsFunction jsFunction = fun;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "generateDefaultSetterFunction"));
        }
        return jsFunction;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultAccessor(@NotNull PropertyAccessorDescriptor accessorDescriptor, @NotNull JsFunction function) {
        if (accessorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "generateDefaultAccessor"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "generateDefaultAccessor"));
        }
        JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function, accessorDescriptor, this.context());
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "generateDefaultAccessor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    private TranslationContext propertyAccessContext(@NotNull PropertySetterDescriptor propertySetterDescriptor) {
        if (propertySetterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "propertyAccessContext"));
        }
        TranslationContext translationContext = this.context().newDeclaration(propertySetterDescriptor);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "propertyAccessContext"));
        }
        return translationContext;
    }

    @NotNull
    private JsPropertyInitializer translateCustomAccessor(@NotNull JetPropertyAccessor expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "translateCustomAccessor"));
        }
        FunctionTranslator translator = Translation.functionTranslator(expression, this.context());
        JsPropertyInitializer jsPropertyInitializer = translator.translateAsEcma5PropertyDescriptor();
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/PropertyTranslator", "translateCustomAccessor"));
        }
        return jsPropertyInitializer;
    }
}

