/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.error;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public final class ErrorClassDescriptor
extends ClassDescriptorImpl {
    public ErrorClassDescriptor(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/error/ErrorClassDescriptor", "<init>"));
        }
        super(ErrorUtils.getErrorModule(), Collections.<AnnotationDescriptor>emptyList(), Modality.OPEN, Name.special("<ERROR CLASS: " + debugMessage + ">"));
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Set<ConstructorDescriptor> set2 = ErrorUtils.getErrorConstructorGroup();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/error/ErrorClassDescriptor", "getConstructors"));
        }
        return set2;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = Modality.OPEN;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/error/ErrorClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/error/ErrorClassDescriptor", "substitute"));
        }
        ErrorClassDescriptor errorClassDescriptor = this;
        if (errorClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/error/ErrorClassDescriptor", "substitute"));
        }
        return errorClassDescriptor;
    }

    @Override
    public String toString() {
        return this.getName().asString();
    }

    public void initializeErrorClass() {
        this.initialize(true, Collections.emptyList(), Collections.<JetType>emptyList(), ErrorUtils.createErrorScope("ERROR_CLASS"), ErrorUtils.getErrorConstructorGroup(), ErrorUtils.getErrorConstructor(), false);
    }
}

