/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.utils.CommonSuppliers;

public class SubstitutionUtils {
    @NotNull
    public static Map<TypeConstructor, TypeProjection> buildSubstitutionContext(@NotNull JetType context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildSubstitutionContext"));
        }
        Map<TypeConstructor, TypeProjection> map = SubstitutionUtils.buildSubstitutionContext(context.getConstructor().getParameters(), context.getArguments());
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildSubstitutionContext"));
        }
        return map;
    }

    @NotNull
    public static TypeSubstitutor buildDeepSubstitutor(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildDeepSubstitutor"));
        }
        HashMap<TypeConstructor, TypeProjection> substitution = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(substitution);
        SubstitutionUtils.fillInDeepSubstitutor(type, typeSubstitutor, substitution, null);
        TypeSubstitutor typeSubstitutor2 = typeSubstitutor;
        if (typeSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildDeepSubstitutor"));
        }
        return typeSubstitutor2;
    }

    @NotNull
    public static Multimap<TypeConstructor, TypeProjection> buildDeepSubstitutionMultimap(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildDeepSubstitutionMultimap"));
        }
        SetMultimap<TypeConstructor, TypeProjection> fullSubstitution = CommonSuppliers.newLinkedHashSetHashSetMultimap();
        HashMap<TypeConstructor, TypeProjection> substitution = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(substitution);
        SubstitutionUtils.fillInDeepSubstitutor(type, typeSubstitutor, substitution, fullSubstitution);
        SetMultimap<TypeConstructor, TypeProjection> setMultimap = fullSubstitution;
        if (setMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildDeepSubstitutionMultimap"));
        }
        return setMultimap;
    }

    private static void fillInDeepSubstitutor(@NotNull JetType context, @NotNull TypeSubstitutor substitutor, @NotNull Map<TypeConstructor, TypeProjection> substitution, @Nullable Multimap<TypeConstructor, TypeProjection> fullSubstitution) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/SubstitutionUtils", "fillInDeepSubstitutor"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/SubstitutionUtils", "fillInDeepSubstitutor"));
        }
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/types/SubstitutionUtils", "fillInDeepSubstitutor"));
        }
        List<TypeParameterDescriptor> parameters = context.getConstructor().getParameters();
        List<TypeProjection> arguments = context.getArguments();
        if (parameters.size() != arguments.size()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < arguments.size(); ++i) {
            TypeProjection argument = arguments.get(i);
            TypeParameterDescriptor parameter = parameters.get(i);
            TypeProjection substitute = substitutor.substitute(argument);
            assert (substitute != null);
            substitution.put(parameter.getTypeConstructor(), substitute);
            if (fullSubstitution == null) continue;
            fullSubstitution.put(parameter.getTypeConstructor(), substitute);
        }
        if (KotlinBuiltIns.getInstance().isNothingOrNullableNothing(context)) {
            return;
        }
        for (JetType supertype : context.getConstructor().getSupertypes()) {
            SubstitutionUtils.fillInDeepSubstitutor(supertype, substitutor, substitution, fullSubstitution);
        }
    }

    @NotNull
    public static Map<TypeConstructor, TypeProjection> buildSubstitutionContext(@NotNull List<TypeParameterDescriptor> parameters, @NotNull List<TypeProjection> contextArguments) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildSubstitutionContext"));
        }
        if (contextArguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildSubstitutionContext"));
        }
        HashMap<TypeConstructor, TypeProjection> parameterValues = new HashMap<TypeConstructor, TypeProjection>();
        SubstitutionUtils.fillInSubstitutionContext(parameters, contextArguments, parameterValues);
        HashMap<TypeConstructor, TypeProjection> hashMap = parameterValues;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/SubstitutionUtils", "buildSubstitutionContext"));
        }
        return hashMap;
    }

    private static void fillInSubstitutionContext(List<TypeParameterDescriptor> parameters, List<TypeProjection> contextArguments, Map<TypeConstructor, TypeProjection> parameterValues) {
        if (parameters.size() != contextArguments.size()) {
            throw new IllegalArgumentException("type parameter count != context arguments");
        }
        int parametersSize = parameters.size();
        for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameter = parameters.get(i);
            TypeProjection value = contextArguments.get(i);
            parameterValues.put(parameter.getTypeConstructor(), value);
        }
    }

    @NotNull
    public static TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/SubstitutionUtils", "makeStarProjection"));
        }
        TypeProjection typeProjection = new TypeProjection(parameterDescriptor.getVariance() == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE, parameterDescriptor.getUpperBoundsAsType());
        if (typeProjection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/SubstitutionUtils", "makeStarProjection"));
        }
        return typeProjection;
    }

    public static boolean hasUnsubstitutedTypeParameters(JetType type) {
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return true;
        }
        for (TypeProjection proj : type.getArguments()) {
            if (!SubstitutionUtils.hasUnsubstitutedTypeParameters(proj.getType())) continue;
            return true;
        }
        return false;
    }

    public static Map<TypeConstructor, TypeProjection> removeTrivialSubstitutions(Map<TypeConstructor, TypeProjection> context) {
        HashMap<TypeConstructor, TypeProjection> clean = Maps.newHashMap(context);
        boolean changed = false;
        Iterator iterator2 = clean.entrySet().iterator();
        while (iterator2.hasNext()) {
            TypeProjection value;
            Map.Entry entry = iterator2.next();
            TypeConstructor key = (TypeConstructor)entry.getKey();
            if (key != (value = (TypeProjection)entry.getValue()).getType().getConstructor() || value.getProjectionKind() != Variance.INVARIANT) continue;
            iterator2.remove();
            changed = true;
        }
        return changed ? clean : context;
    }

    public static void assertNotImmediatelyRecursive(Map<TypeConstructor, TypeProjection> context) {
        for (Map.Entry<TypeConstructor, TypeProjection> entry : context.entrySet()) {
            TypeProjection value;
            TypeConstructor key = entry.getKey();
            if (!TypeUtils.typeConstructorUsedInType(key, (value = entry.getValue()).getType())) continue;
            throw new IllegalStateException("Immediately recursive substitution: " + context + "\nProblematic parameter: " + key + " -> " + value);
        }
    }
}

