/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.IntersectionTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CommonSupertypes {
    @Nullable
    public static JetType commonSupertypeForNonDenotableTypes(@NotNull Collection<JetType> types) {
        JetType type;
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSupertypeForNonDenotableTypes"));
        }
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1 && (type = types.iterator().next()).getConstructor() instanceof IntersectionTypeConstructor) {
            return CommonSupertypes.commonSupertypeForNonDenotableTypes(type.getConstructor().getSupertypes());
        }
        return CommonSupertypes.commonSupertype(types);
    }

    @NotNull
    public static JetType commonSupertype(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSupertype"));
        }
        assert (!types.isEmpty());
        HashSet<JetType> typeSet = new HashSet<JetType>(types);
        if (typeSet.size() == 1) {
            JetType jetType = (JetType)typeSet.iterator().next();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSupertype"));
            }
            return jetType;
        }
        boolean nullable = false;
        Iterator iterator2 = typeSet.iterator();
        while (iterator2.hasNext()) {
            JetType type = (JetType)iterator2.next();
            assert (type != null);
            if (KotlinBuiltIns.getInstance().isNothingOrNullableNothing(type)) {
                iterator2.remove();
            }
            if (type.isError()) {
                JetType jetType = ErrorUtils.createErrorType("Supertype of error type " + type);
                if (jetType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSupertype"));
                }
                return jetType;
            }
            nullable |= type.isNullable();
        }
        if (typeSet.isEmpty()) {
            JetType jetType = nullable ? KotlinBuiltIns.getInstance().getNullableNothingType() : KotlinBuiltIns.getInstance().getNothingType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSupertype"));
            }
            return jetType;
        }
        if (typeSet.size() == 1) {
            JetType jetType = TypeUtils.makeNullableIfNeeded((JetType)typeSet.iterator().next(), nullable);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSupertype"));
            }
            return jetType;
        }
        Map<TypeConstructor, Set<JetType>> commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(typeSet);
        while (commonSupertypes.size() > 1) {
            HashSet<JetType> merge = new HashSet<JetType>();
            for (Set<JetType> supertypes : commonSupertypes.values()) {
                merge.addAll(supertypes);
            }
            commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(merge);
        }
        assert (!commonSupertypes.isEmpty()) : commonSupertypes + " <- " + types;
        Map.Entry<TypeConstructor, Set<JetType>> entry = commonSupertypes.entrySet().iterator().next();
        JetType result = CommonSupertypes.computeSupertypeProjections(entry.getKey(), entry.getValue());
        JetType jetType = TypeUtils.makeNullableIfNeeded(result, nullable);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "commonSupertype"));
        }
        return jetType;
    }

    @NotNull
    private static Map<TypeConstructor, Set<JetType>> computeCommonRawSupertypes(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        assert (!types.isEmpty());
        HashMap<TypeConstructor, Set<JetType>> constructorToAllInstances = new HashMap<TypeConstructor, Set<JetType>>();
        HashSet<TypeConstructor> commonSuperclasses = null;
        List<TypeConstructor> order = null;
        for (JetType type : types) {
            HashSet<TypeConstructor> visited = Sets.newHashSet();
            order = TypeUtils.topologicallySortSuperclassesAndRecordAllInstances(type, constructorToAllInstances, visited);
            if (commonSuperclasses == null) {
                commonSuperclasses = visited;
                continue;
            }
            commonSuperclasses.retainAll(visited);
        }
        assert (order != null);
        HashSet<TypeConstructor> notSource = new HashSet<TypeConstructor>();
        HashMap<TypeConstructor, Set<JetType>> result = new HashMap<TypeConstructor, Set<JetType>>();
        for (TypeConstructor superConstructor : order) {
            if (!commonSuperclasses.contains(superConstructor) || notSource.contains(superConstructor)) continue;
            result.put(superConstructor, (Set<JetType>)constructorToAllInstances.get(superConstructor));
            CommonSupertypes.markAll(superConstructor, notSource);
        }
        HashMap<TypeConstructor, Set<JetType>> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        return hashMap;
    }

    @NotNull
    private static JetType computeSupertypeProjections(@NotNull TypeConstructor constructor, @NotNull Set<JetType> types) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        assert (!types.isEmpty());
        if (types.size() == 1) {
            JetType jetType = types.iterator().next();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjections"));
            }
            return jetType;
        }
        List<TypeParameterDescriptor> parameters = constructor.getParameters();
        ArrayList<TypeProjection> newProjections = new ArrayList<TypeProjection>();
        int parametersSize = parameters.size();
        for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters.get(i);
            HashSet<TypeProjection> typeProjections = new HashSet<TypeProjection>();
            for (JetType type : types) {
                typeProjections.add(type.getArguments().get(i));
            }
            newProjections.add(CommonSupertypes.computeSupertypeProjection(parameterDescriptor, typeProjections));
        }
        boolean nullable = false;
        for (JetType type : types) {
            nullable |= type.isNullable();
        }
        KotlinBuiltIns.getInstance();
        JetScope newScope = KotlinBuiltIns.STUB;
        ClassifierDescriptor declarationDescriptor = constructor.getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            newScope = ((ClassDescriptor)declarationDescriptor).getMemberScope(newProjections);
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), constructor, nullable, newProjections, newScope);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        return jetTypeImpl;
    }

    @NotNull
    private static TypeProjection computeSupertypeProjection(@NotNull TypeParameterDescriptor parameterDescriptor, @NotNull Set<TypeProjection> typeProjections) {
        Variance projectionKind;
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        if (typeProjections == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        if (typeProjections.size() == 1) {
            TypeProjection typeProjection = typeProjections.iterator().next();
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjection;
        }
        HashSet<JetType> ins = new HashSet<JetType>();
        HashSet<JetType> outs = new HashSet<JetType>();
        Variance variance = parameterDescriptor.getVariance();
        switch (variance) {
            case INVARIANT: {
                break;
            }
            case IN_VARIANCE: {
                outs = null;
                break;
            }
            case OUT_VARIANCE: {
                ins = null;
            }
        }
        for (TypeProjection projection : typeProjections) {
            Variance projectionKind2 = projection.getProjectionKind();
            if (projectionKind2.allowsInPosition()) {
                if (ins != null) {
                    ins.add(projection.getType());
                }
            } else {
                ins = null;
            }
            if (projectionKind2.allowsOutPosition()) {
                if (outs == null) continue;
                outs.add(projection.getType());
                continue;
            }
            outs = null;
        }
        if (ins != null) {
            JetType intersection = TypeUtils.intersect(JetTypeChecker.INSTANCE, ins);
            if (intersection == null) {
                if (outs != null) {
                    TypeProjection typeProjection = new TypeProjection(Variance.OUT_VARIANCE, CommonSupertypes.commonSupertype(outs));
                    if (typeProjection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
                    }
                    return typeProjection;
                }
                TypeProjection typeProjection = new TypeProjection(Variance.OUT_VARIANCE, CommonSupertypes.commonSupertype(parameterDescriptor.getUpperBounds()));
                if (typeProjection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
                }
                return typeProjection;
            }
            Variance projectionKind3 = variance == Variance.IN_VARIANCE ? Variance.INVARIANT : Variance.IN_VARIANCE;
            TypeProjection typeProjection = new TypeProjection(projectionKind3, intersection);
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjection;
        }
        if (outs != null) {
            projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            TypeProjection typeProjection = new TypeProjection(projectionKind, CommonSupertypes.commonSupertype(outs));
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjection;
        }
        projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        TypeProjection typeProjection = new TypeProjection(projectionKind, CommonSupertypes.commonSupertype(parameterDescriptor.getUpperBounds()));
        if (typeProjection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        return typeProjection;
    }

    private static void markAll(@NotNull TypeConstructor typeConstructor, @NotNull Set<TypeConstructor> markerSet) {
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/CommonSupertypes", "markAll"));
        }
        if (markerSet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/CommonSupertypes", "markAll"));
        }
        markerSet.add(typeConstructor);
        for (JetType type : typeConstructor.getSupertypes()) {
            CommonSupertypes.markAll(type.getConstructor(), markerSet);
        }
    }
}

