/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;

class ImportsProvider {
    private final List<JetImportDirective> importDirectives;
    private final NotNullLazyValue<NameToImportsCache> importsCacheValue;

    public ImportsProvider(StorageManager storageManager, final List<JetImportDirective> importDirectives) {
        this.importDirectives = importDirectives;
        this.importsCacheValue = storageManager.createLazyValue(new Function0<NameToImportsCache>(){

            @Override
            public NameToImportsCache invoke() {
                return NameToImportsCache.createIndex(importDirectives);
            }
        });
    }

    @NotNull
    public List<JetImportDirective> getImports(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/ImportsProvider", "getImports"));
        }
        List list2 = this.importsCacheValue.invoke().getImports(name);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ImportsProvider", "getImports"));
        }
        return list2;
    }

    @NotNull
    public List<JetImportDirective> getAllImports() {
        List<JetImportDirective> list2 = this.importDirectives;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ImportsProvider", "getAllImports"));
        }
        return list2;
    }

    private static class NameToImportsCache {
        private final ListMultimap<Name, JetImportDirective> nameToDirectives;
        private final List<JetImportDirective> allUnderImports;

        private NameToImportsCache(ListMultimap<Name, JetImportDirective> directives, List<JetImportDirective> imports) {
            this.nameToDirectives = directives;
            this.allUnderImports = imports;
        }

        private List<JetImportDirective> getImports(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/ImportsProvider$NameToImportsCache", "getImports"));
            }
            return this.nameToDirectives.containsKey(name) ? this.nameToDirectives.get(name) : this.allUnderImports;
        }

        private static NameToImportsCache createIndex(List<JetImportDirective> importDirectives) {
            ImmutableListMultimap.Builder namesToRelativeImportsBuilder = ImmutableListMultimap.builder();
            HashSet<Name> processedAliases = Sets.newHashSet();
            ArrayList<JetImportDirective> processedAllUnderImports = Lists.newArrayList();
            for (JetImportDirective anImport : importDirectives) {
                ImportPath path = JetPsiUtil.getImportPath(anImport);
                if (path == null) continue;
                if (path.isAllUnder()) {
                    processedAllUnderImports.add(anImport);
                    for (Name aliasName : processedAliases) {
                        namesToRelativeImportsBuilder.put(aliasName, anImport);
                    }
                    continue;
                }
                Name aliasName = path.getImportedName();
                assert (aliasName != null);
                if (!processedAliases.contains(aliasName)) {
                    processedAliases.add(aliasName);
                    namesToRelativeImportsBuilder.putAll(aliasName, processedAllUnderImports);
                }
                namesToRelativeImportsBuilder.put(aliasName, anImport);
            }
            return new NameToImportsCache((ListMultimap<Name, JetImportDirective>)((Object)namesToRelativeImportsBuilder.build()), ImmutableList.copyOf(processedAllUnderImports));
        }
    }
}

