/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeSubstitutor;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeSubstitutorImpl;

public class JavaClassifierTypeImpl
extends JavaTypeImpl<PsiClassType>
implements JavaClassifierType {
    private ResolutionResult resolutionResult;

    public JavaClassifierTypeImpl(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassifierTypeImpl", "<init>"));
        }
        super(psiClassType);
    }

    @Override
    @Nullable
    public JavaClassifier getClassifier() {
        this.resolve();
        return this.resolutionResult.classifier;
    }

    @Override
    @NotNull
    public JavaTypeSubstitutor getSubstitutor() {
        this.resolve();
        JavaTypeSubstitutor javaTypeSubstitutor = this.resolutionResult.substitutor;
        if (javaTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassifierTypeImpl", "getSubstitutor"));
        }
        return javaTypeSubstitutor;
    }

    private void resolve() {
        if (this.resolutionResult == null) {
            PsiClassType.ClassResolveResult result = ((PsiClassType)this.getPsi()).resolveGenerics();
            PsiClass psiClass = result.getElement();
            this.resolutionResult = new ResolutionResult(psiClass == null ? null : JavaClassifierImpl.create(psiClass), new JavaTypeSubstitutorImpl(result.getSubstitutor()));
        }
    }

    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        PsiType[] psiTypes = ((PsiClassType)this.getPsi()).getSuperTypes();
        if (psiTypes.length == 0) {
            List<JavaClassifierType> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassifierTypeImpl", "getSupertypes"));
            }
            return list2;
        }
        ArrayList<JavaClassifierType> result = new ArrayList<JavaClassifierType>(psiTypes.length);
        for (PsiType psiType : psiTypes) {
            if (!(psiType instanceof PsiClassType)) {
                throw new IllegalStateException("Supertype should be a class: " + psiType + ", type: " + this.getPsi());
            }
            result.add(new JavaClassifierTypeImpl((PsiClassType)psiType));
        }
        ArrayList<JavaClassifierType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassifierTypeImpl", "getSupertypes"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = ((PsiClassType)this.getPsi()).getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassifierTypeImpl", "getPresentableText"));
        }
        return string;
    }

    @Override
    public boolean isRaw() {
        return ((PsiClassType)this.getPsi()).isRaw();
    }

    @Override
    @NotNull
    public Collection<JavaType> getTypeArguments() {
        Collection<JavaType> collection = JavaElementCollectionFromPsiArrayUtil.types(((PsiClassType)this.getPsi()).getParameters());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassifierTypeImpl", "getTypeArguments"));
        }
        return collection;
    }

    private static class ResolutionResult {
        private final JavaClassifier classifier;
        private final JavaTypeSubstitutor substitutor;

        private ResolutionResult(@Nullable JavaClassifier classifier, @NotNull JavaTypeSubstitutor substitutor) {
            if (substitutor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassifierTypeImpl$ResolutionResult", "<init>"));
            }
            this.classifier = classifier;
            this.substitutor = substitutor;
        }
    }
}

