/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.descriptor.SamConstructorDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaFunctionResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.ProgressChecker;
import org.jetbrains.jet.lang.resolve.java.scope.JavaBaseScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JavaPackageScope
extends JavaBaseScope {
    @NotNull
    private final JavaPackage javaPackage;
    @NotNull
    private final FqName packageFQN;

    public JavaPackageScope(@NotNull NamespaceDescriptor descriptor, @NotNull JavaPackage javaPackage, @NotNull FqName packageFQN, @NotNull JavaMemberResolver memberResolver) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "<init>"));
        }
        if (javaPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "<init>"));
        }
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "<init>"));
        }
        if (memberResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "<init>"));
        }
        super(descriptor, memberResolver, MembersProvider.forPackage(javaPackage));
        this.javaPackage = javaPackage;
        this.packageFQN = packageFQN;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "getClassifier"));
        }
        ClassDescriptor classDescriptor = this.memberResolver.resolveClass(this.packageFQN.child(name), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        if (classDescriptor == null || classDescriptor.getKind().isObject()) {
            return null;
        }
        return classDescriptor;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "getObjectDescriptor"));
        }
        ClassDescriptor classDescriptor = this.memberResolver.resolveClass(this.packageFQN.child(name), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        if (classDescriptor != null && classDescriptor.getKind().isObject()) {
            return classDescriptor;
        }
        return null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "getNamespace"));
        }
        return this.memberResolver.resolveNamespace(this.packageFQN.child(name), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeAllDescriptors() {
        Collection<DeclarationDescriptor> result = super.computeAllDescriptors();
        result.addAll(this.computeAllPackageDeclarations());
        Collection<DeclarationDescriptor> collection = result;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "computeAllDescriptors"));
        }
        return collection;
    }

    @NotNull
    private Collection<DeclarationDescriptor> computeAllPackageDeclarations() {
        HashSet<DeclarationDescriptor> result = new HashSet<DeclarationDescriptor>();
        for (JavaPackage subPackage : this.javaPackage.getSubPackages()) {
            NamespaceDescriptor childNs = this.memberResolver.resolveNamespace(subPackage.getFqName(), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
            if (childNs == null) continue;
            result.add(childNs);
        }
        for (JavaClass javaClass : DescriptorResolverUtils.getClassesInPackage(this.javaPackage)) {
            NamespaceDescriptor namespace;
            if (DescriptorResolverUtils.isCompiledKotlinPackageClass(javaClass) || javaClass.getOriginKind() == JavaClass.OriginKind.KOTLIN_LIGHT_CLASS || javaClass.getVisibility() != Visibilities.PUBLIC) continue;
            ProgressChecker.getInstance().checkCanceled();
            FqName fqName = javaClass.getFqName();
            if (fqName == null) continue;
            ClassDescriptor classDescriptor = this.memberResolver.resolveClass(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
            if (classDescriptor != null) {
                result.add(classDescriptor);
            }
            if ((namespace = this.memberResolver.resolveNamespace(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES)) == null) continue;
            result.add(namespace);
        }
        HashSet<DeclarationDescriptor> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "computeAllPackageDeclarations"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    protected Set<FunctionDescriptor> computeFunctionDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "computeFunctionDescriptor"));
        }
        NamedMembers members = this.membersProvider.get(name);
        if (members == null) {
            Set<FunctionDescriptor> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "computeFunctionDescriptor"));
            }
            return set2;
        }
        SamConstructorDescriptor samConstructor = JavaFunctionResolver.resolveSamConstructor((NamespaceDescriptor)this.descriptor, members);
        if (samConstructor == null) {
            Set<FunctionDescriptor> set3 = Collections.emptySet();
            if (set3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "computeFunctionDescriptor"));
            }
            return set3;
        }
        Set<FunctionDescriptor> set4 = Collections.singleton(samConstructor);
        if (set4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "computeFunctionDescriptor"));
        }
        return set4;
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        List<ClassDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPackageScope", "computeInnerClasses"));
        }
        return list2;
    }
}

