/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.ProgressChecker;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;

public abstract class JavaBaseScope
extends JetScopeImpl {
    @NotNull
    protected final JavaMemberResolver memberResolver;
    @NotNull
    protected final MembersProvider membersProvider;
    @NotNull
    private final Map<Name, Set<FunctionDescriptor>> functionDescriptors;
    @NotNull
    private final Map<Name, Set<VariableDescriptor>> propertyDescriptors;
    @Nullable
    private Collection<DeclarationDescriptor> allDescriptors;
    @Nullable
    private Set<ClassDescriptor> objectDescriptors;
    @NotNull
    protected final ClassOrNamespaceDescriptor descriptor;
    private Collection<ClassDescriptor> innerClasses;

    protected JavaBaseScope(@NotNull ClassOrNamespaceDescriptor descriptor, @NotNull JavaMemberResolver memberResolver, @NotNull MembersProvider membersProvider) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "<init>"));
        }
        if (memberResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "<init>"));
        }
        if (membersProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "<init>"));
        }
        this.functionDescriptors = new HashMap<Name, Set<FunctionDescriptor>>();
        this.propertyDescriptors = new HashMap<Name, Set<VariableDescriptor>>();
        this.allDescriptors = null;
        this.objectDescriptors = null;
        this.innerClasses = null;
        this.memberResolver = memberResolver;
        this.membersProvider = membersProvider;
        this.descriptor = descriptor;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        ClassOrNamespaceDescriptor classOrNamespaceDescriptor = this.descriptor;
        if (classOrNamespaceDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getContainingDeclaration"));
        }
        return classOrNamespaceDescriptor;
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getProperties"));
        }
        Set<VariableDescriptor> cached = this.propertyDescriptors.get(name);
        if (cached != null) {
            Set<VariableDescriptor> set2 = cached;
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getProperties"));
            }
            return set2;
        }
        if (this.allDescriptorsComputed()) {
            Set<VariableDescriptor> set3 = Collections.emptySet();
            if (set3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getProperties"));
            }
            return set3;
        }
        Set<VariableDescriptor> computedDescriptors = this.computePropertyDescriptors(name);
        this.propertyDescriptors.put(name, computedDescriptors);
        Set<VariableDescriptor> set4 = computedDescriptors;
        if (set4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getProperties"));
        }
        return set4;
    }

    @NotNull
    private Set<VariableDescriptor> computePropertyDescriptors(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "computePropertyDescriptors"));
        }
        NamedMembers members = this.membersProvider.get(name);
        if (members == null) {
            Set<VariableDescriptor> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "computePropertyDescriptors"));
            }
            return set2;
        }
        Set<VariableDescriptor> set3 = this.memberResolver.resolveFieldGroup(members, this.descriptor);
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "computePropertyDescriptors"));
        }
        return set3;
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getFunctions"));
        }
        Set<FunctionDescriptor> cached = this.functionDescriptors.get(name);
        if (cached != null) {
            Set<FunctionDescriptor> set2 = cached;
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getFunctions"));
            }
            return set2;
        }
        if (this.allDescriptorsComputed()) {
            Set<FunctionDescriptor> set3 = Collections.emptySet();
            if (set3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getFunctions"));
            }
            return set3;
        }
        Set<FunctionDescriptor> computedDescriptors = this.computeFunctionDescriptor(name);
        this.functionDescriptors.put(name, computedDescriptors);
        Set<FunctionDescriptor> set4 = computedDescriptors;
        if (set4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getFunctions"));
        }
        return set4;
    }

    @NotNull
    protected abstract Set<FunctionDescriptor> computeFunctionDescriptor(@NotNull Name var1);

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptorsComputed()) {
            Collection<DeclarationDescriptor> collection = this.allDescriptors;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getAllDescriptors"));
            }
            return collection;
        }
        Collection<DeclarationDescriptor> collection = this.allDescriptors = this.computeAllDescriptors();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getAllDescriptors"));
        }
        return collection;
    }

    private boolean allDescriptorsComputed() {
        return this.allDescriptors != null;
    }

    @NotNull
    protected Collection<DeclarationDescriptor> computeAllDescriptors() {
        HashSet<DeclarationDescriptor> result = new HashSet<DeclarationDescriptor>();
        result.addAll(this.computeFieldAndFunctionDescriptors());
        result.addAll(JavaBaseScope.filterObjects(this.getInnerClasses(), false));
        HashSet<DeclarationDescriptor> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "computeAllDescriptors"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<ClassDescriptor> getObjectDescriptors() {
        if (this.objectDescriptors == null) {
            this.objectDescriptors = new HashSet<ClassDescriptor>(JavaBaseScope.filterObjects(this.getInnerClasses(), true));
        }
        Set<ClassDescriptor> set2 = this.objectDescriptors;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getObjectDescriptors"));
        }
        return set2;
    }

    @NotNull
    protected abstract Collection<ClassDescriptor> computeInnerClasses();

    @NotNull
    private Collection<DeclarationDescriptor> computeFieldAndFunctionDescriptors() {
        ArrayList<DeclarationDescriptor> result = new ArrayList<DeclarationDescriptor>();
        for (NamedMembers members : this.membersProvider.allMembers()) {
            Name name = members.getName();
            ProgressChecker.getInstance().checkCanceled();
            result.addAll(this.getFunctions(name));
            ProgressChecker.getInstance().checkCanceled();
            result.addAll(this.getProperties(name));
        }
        ArrayList<DeclarationDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "computeFieldAndFunctionDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    protected Collection<ClassDescriptor> getInnerClasses() {
        if (this.innerClasses == null) {
            this.innerClasses = this.computeInnerClasses();
        }
        Collection<ClassDescriptor> collection = this.innerClasses;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "getInnerClasses"));
        }
        return collection;
    }

    @NotNull
    private static Collection<ClassDescriptor> filterObjects(@NotNull Collection<ClassDescriptor> classes, boolean objects) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "filterObjects"));
        }
        ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>();
        for (ClassDescriptor descriptor : classes) {
            if (descriptor.getKind().isObject() != objects) continue;
            result.add(descriptor);
        }
        ArrayList<ClassDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaBaseScope", "filterObjects"));
        }
        return arrayList;
    }
}

