/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.java.structure.JavaWildcardType;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class JavaTypeTransformer {
    private JavaClassResolver classResolver;

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @NotNull
    private TypeProjection transformToTypeProjection(@NotNull JavaType type, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeVariableResolver typeVariableResolver, @NotNull TypeUsage howThisTypeIsUsed) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToTypeProjection"));
        }
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToTypeProjection"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToTypeProjection"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToTypeProjection"));
        }
        if (!(type instanceof JavaWildcardType)) {
            TypeProjection typeProjection = new TypeProjection(this.transformToType(type, howThisTypeIsUsed, typeVariableResolver));
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToTypeProjection"));
            }
            return typeProjection;
        }
        JavaWildcardType wildcardType = (JavaWildcardType)type;
        JavaType bound = wildcardType.getBound();
        if (bound == null) {
            TypeProjection typeProjection = SubstitutionUtils.makeStarProjection(typeParameterDescriptor);
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToTypeProjection"));
            }
            return typeProjection;
        }
        Variance variance = wildcardType.isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE;
        TypeProjection typeProjection = new TypeProjection(variance, this.transformToType(bound, TypeUsage.UPPER_BOUND, typeVariableResolver));
        if (typeProjection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToTypeProjection"));
        }
        return typeProjection;
    }

    @NotNull
    public JetType transformToType(@NotNull JavaType type, @NotNull TypeVariableResolver typeVariableResolver) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToType"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToType"));
        }
        JetType jetType = this.transformToType(type, TypeUsage.MEMBER_SIGNATURE_INVARIANT, typeVariableResolver);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToType"));
        }
        return jetType;
    }

    @NotNull
    public JetType transformToType(@NotNull JavaType type, @NotNull TypeUsage howThisTypeIsUsed, @NotNull TypeVariableResolver typeVariableResolver) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToType"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToType"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToType"));
        }
        if (type instanceof JavaClassifierType) {
            JavaClassifierType classifierType = (JavaClassifierType)type;
            JetType jetType = this.transformClassifierType(classifierType, howThisTypeIsUsed, typeVariableResolver);
            if (jetType == null) {
                JetType jetType2 = ErrorUtils.createErrorType("Unresolved java classifier: " + classifierType.getPresentableText());
                if (jetType2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToType"));
                }
                return jetType2;
            }
            JetType jetType3 = jetType;
            if (jetType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToType"));
            }
            return jetType3;
        }
        if (type instanceof JavaPrimitiveType) {
            String canonicalText = ((JavaPrimitiveType)type).getCanonicalText();
            JetType jetType = JavaToKotlinClassMap.getInstance().mapPrimitiveKotlinClass(canonicalText);
            assert (jetType != null) : "Primitive type is not found: " + canonicalText;
            JetType jetType4 = jetType;
            if (jetType4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToType"));
            }
            return jetType4;
        }
        if (type instanceof JavaArrayType) {
            JetType jetType = this.transformArrayType((JavaArrayType)type, howThisTypeIsUsed, typeVariableResolver, false);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformToType"));
            }
            return jetType;
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    @Nullable
    private JetType transformClassifierType(@NotNull JavaClassifierType classifierType, @NotNull TypeUsage howThisTypeIsUsed, @NotNull TypeVariableResolver typeVariableResolver) {
        if (classifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformClassifierType"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformClassifierType"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformClassifierType"));
        }
        JavaClassifier javaClassifier = classifierType.getClassifier();
        if (javaClassifier == null) {
            return null;
        }
        if (javaClassifier instanceof JavaTypeParameter) {
            return this.transformTypeParameter((JavaTypeParameter)javaClassifier, howThisTypeIsUsed, typeVariableResolver);
        }
        if (javaClassifier instanceof JavaClass) {
            FqName fqName = ((JavaClass)javaClassifier).getFqName();
            assert (fqName != null) : "Class type should have a FQ name: " + javaClassifier;
            return this.transformClassType(fqName, classifierType, howThisTypeIsUsed, typeVariableResolver);
        }
        throw new UnsupportedOperationException("Unsupported classifier: " + javaClassifier);
    }

    @Nullable
    private JetType transformTypeParameter(@NotNull JavaTypeParameter typeParameter, @NotNull TypeUsage howThisTypeIsUsed, @NotNull TypeVariableResolver typeVariableResolver) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformTypeParameter"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformTypeParameter"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformTypeParameter"));
        }
        JavaTypeParameterListOwner owner = typeParameter.getOwner();
        if (owner instanceof JavaMethod && ((JavaMethod)owner).isConstructor()) {
            HashSet<JetType> supertypesJet = new HashSet<JetType>();
            for (JavaClassifierType supertype : typeParameter.getUpperBounds()) {
                supertypesJet.add(this.transformToType(supertype, TypeUsage.UPPER_BOUND, typeVariableResolver));
            }
            return TypeUtils.intersect(JetTypeChecker.INSTANCE, supertypesJet);
        }
        TypeParameterDescriptor descriptor = typeVariableResolver.getTypeVariable(typeParameter.getName());
        if (descriptor == null) {
            return null;
        }
        boolean nullable = !EnumSet.of(TypeUsage.TYPE_ARGUMENT, TypeUsage.UPPER_BOUND, TypeUsage.SUPERTYPE_ARGUMENT).contains((Object)howThisTypeIsUsed);
        return TypeUtils.makeNullableIfNeeded(descriptor.getDefaultType(), nullable);
    }

    @Nullable
    private JetType transformClassType(@NotNull FqName fqName, @NotNull JavaClassifierType classifierType, @NotNull TypeUsage howThisTypeIsUsed, @NotNull TypeVariableResolver typeVariableResolver) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformClassType"));
        }
        if (classifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformClassType"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformClassType"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformClassType"));
        }
        boolean nullable = !EnumSet.of(TypeUsage.TYPE_ARGUMENT, TypeUsage.SUPERTYPE_ARGUMENT, TypeUsage.SUPERTYPE).contains((Object)howThisTypeIsUsed);
        ClassDescriptor classData = JavaToKotlinClassMap.getInstance().mapKotlinClass(fqName, howThisTypeIsUsed);
        if (classData == null) {
            classData = this.classResolver.resolveClass(fqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
        }
        if (classData == null) {
            return null;
        }
        ArrayList<TypeProjection> arguments = new ArrayList<TypeProjection>();
        List<TypeParameterDescriptor> parameters = classData.getTypeConstructor().getParameters();
        if (JavaTypeTransformer.isRaw(classifierType, !parameters.isEmpty())) {
            for (TypeParameterDescriptor parameter : parameters) {
                Variance projectionKind = parameter.getVariance() == Variance.OUT_VARIANCE || howThisTypeIsUsed == TypeUsage.SUPERTYPE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
                arguments.add(new TypeProjection(projectionKind, KotlinBuiltIns.getInstance().getNullableAnyType()));
            }
        } else {
            Collection<JavaType> javaTypeArguments = classifierType.getTypeArguments();
            if (parameters.size() != javaTypeArguments.size()) {
                for (TypeParameterDescriptor parameter : parameters) {
                    arguments.add(new TypeProjection(ErrorUtils.createErrorType(parameter.getName().asString())));
                }
            } else {
                int index = 0;
                for (JavaType typeArgument : javaTypeArguments) {
                    TypeParameterDescriptor typeParameterDescriptor = parameters.get(index);
                    ++index;
                    TypeUsage howTheProjectionIsUsed = howThisTypeIsUsed == TypeUsage.SUPERTYPE ? TypeUsage.SUPERTYPE_ARGUMENT : TypeUsage.TYPE_ARGUMENT;
                    TypeProjection typeProjection = this.transformToTypeProjection(typeArgument, typeParameterDescriptor, typeVariableResolver, howTheProjectionIsUsed);
                    if (typeProjection.getProjectionKind() == typeParameterDescriptor.getVariance()) {
                        arguments.add(new TypeProjection(Variance.INVARIANT, typeProjection.getType()));
                        continue;
                    }
                    arguments.add(typeProjection);
                }
            }
        }
        return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), classData.getTypeConstructor(), nullable, arguments, classData.getMemberScope(arguments));
    }

    @NotNull
    private JetType transformArrayType(@NotNull JavaArrayType arrayType, @NotNull TypeUsage howThisTypeIsUsed, @NotNull TypeVariableResolver typeVariableResolver, boolean vararg) {
        JetType jetType;
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformArrayType"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformArrayType"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformArrayType"));
        }
        JavaType componentType = arrayType.getComponentType();
        if (componentType instanceof JavaPrimitiveType && (jetType = JavaToKotlinClassMap.getInstance().mapPrimitiveKotlinClass("[" + ((JavaPrimitiveType)componentType).getCanonicalText())) != null) {
            JetType jetType2 = TypeUtils.makeNullable(jetType);
            if (jetType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformArrayType"));
            }
            return jetType2;
        }
        Variance projectionKind = JavaTypeTransformer.arrayElementTypeProjectionKind(howThisTypeIsUsed, vararg);
        TypeUsage howArgumentTypeIsUsed = vararg ? TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT : TypeUsage.TYPE_ARGUMENT;
        JetType type = this.transformToType(componentType, howArgumentTypeIsUsed, typeVariableResolver);
        JetType jetType3 = TypeUtils.makeNullable(KotlinBuiltIns.getInstance().getArrayType(projectionKind, type));
        if (jetType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformArrayType"));
        }
        return jetType3;
    }

    @NotNull
    private static Variance arrayElementTypeProjectionKind(@NotNull TypeUsage howThisTypeIsUsed, boolean vararg) {
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "arrayElementTypeProjectionKind"));
        }
        if (howThisTypeIsUsed == TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT && !vararg) {
            Variance variance = Variance.OUT_VARIANCE;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "arrayElementTypeProjectionKind"));
            }
            return variance;
        }
        Variance variance = Variance.INVARIANT;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "arrayElementTypeProjectionKind"));
        }
        return variance;
    }

    @NotNull
    public JetType transformVarargType(@NotNull JavaArrayType type, @NotNull TypeUsage howThisTypeIsUsed, @NotNull TypeVariableResolver typeVariableResolver) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformVarargType"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformVarargType"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformVarargType"));
        }
        JetType jetType = this.transformArrayType(type, howThisTypeIsUsed, typeVariableResolver, true);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "transformVarargType"));
        }
        return jetType;
    }

    private static boolean isRaw(@NotNull JavaClassifierType classifierType, boolean argumentsExpected) {
        if (classifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeTransformer", "isRaw"));
        }
        return classifierType.isRaw() || argumentsExpected && classifierType.getTypeArguments().isEmpty();
    }
}

