/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiField;
import com.intellij.util.containers.ComparatorUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeSignatureMismatchException;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.ElementAlternativeSignatureData;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesUtil;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaFieldImpl;
import org.jetbrains.jet.lang.types.JetType;

public class AlternativeFieldSignatureData
extends ElementAlternativeSignatureData {
    private JetType altReturnType;

    public AlternativeFieldSignatureData(@NotNull JavaAnnotationResolver annotationResolver, @NotNull JavaFieldImpl field, @NotNull JetType originalReturnType, boolean isVar) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/AlternativeFieldSignatureData", "<init>"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/AlternativeFieldSignatureData", "<init>"));
        }
        if (originalReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/AlternativeFieldSignatureData", "<init>"));
        }
        String signature = SignaturesUtil.getKotlinSignature(annotationResolver, field);
        if (signature == null) {
            this.setAnnotated(false);
            return;
        }
        this.setAnnotated(true);
        Project project = ((PsiField)field.getPsi()).getProject();
        JetProperty altPropertyDeclaration = JetPsiFactory.createProperty(project, signature);
        try {
            AlternativeFieldSignatureData.checkForSyntaxErrors(altPropertyDeclaration);
            AlternativeFieldSignatureData.checkFieldAnnotation(altPropertyDeclaration, field, isVar);
            this.altReturnType = AlternativeFieldSignatureData.computeReturnType(originalReturnType, altPropertyDeclaration.getTypeRef(), new HashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl>());
        }
        catch (AlternativeSignatureMismatchException e) {
            this.setError(e.getMessage());
        }
    }

    @NotNull
    public JetType getReturnType() {
        this.checkForErrors();
        JetType jetType = this.altReturnType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/AlternativeFieldSignatureData", "getReturnType"));
        }
        return jetType;
    }

    private static void checkFieldAnnotation(@NotNull JetProperty altProperty, @NotNull JavaFieldImpl field, boolean isVar) {
        if (altProperty == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/AlternativeFieldSignatureData", "checkFieldAnnotation"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/AlternativeFieldSignatureData", "checkFieldAnnotation"));
        }
        if (!ComparatorUtil.equalsNullable(field.getName().asString(), altProperty.getName())) {
            throw new AlternativeSignatureMismatchException("Field name mismatch, original: %s, alternative: %s", field.getName().asString(), altProperty.getName());
        }
        if (altProperty.getTypeRef() == null) {
            throw new AlternativeSignatureMismatchException("Field annotation for shouldn't have type reference");
        }
        if (altProperty.getGetter() != null || altProperty.getSetter() != null) {
            throw new AlternativeSignatureMismatchException("Field annotation for shouldn't have getters and setters");
        }
        if (altProperty.isVar() != isVar) {
            throw new AlternativeSignatureMismatchException("Wrong mutability in annotation for field");
        }
        if (altProperty.getInitializer() != null) {
            throw new AlternativeSignatureMismatchException("Default value is not expected in annotation for field");
        }
    }
}

