/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class StringValue
implements CompileTimeConstant<String> {
    private final String value;

    public StringValue(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/constants/StringValue", "getType"));
        }
        JetType jetType = kotlinBuiltIns.getStringType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/StringValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data) {
        return visitor.visitStringValue(this, data);
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValue that = (StringValue)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

