/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.LibrarySourceHacks;
import org.jetbrains.jet.lang.resolve.calls.tasks.CallableDescriptorCollector;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;

public class CallableDescriptorCollectors {
    public static CallableDescriptorCollector<FunctionDescriptor> FUNCTIONS = new FilteredCollector<FunctionDescriptor>(new FunctionCollector());
    public static CallableDescriptorCollector<VariableDescriptor> VARIABLES = new FilteredCollector<VariableDescriptor>(new VariableCollector());
    public static CallableDescriptorCollector<VariableDescriptor> PROPERTIES = new FilteredCollector<VariableDescriptor>(new PropertyCollector());
    public static List<CallableDescriptorCollector<? extends CallableDescriptor>> FUNCTIONS_AND_VARIABLES = Lists.newArrayList(FUNCTIONS, VARIABLES);

    private CallableDescriptorCollectors() {
    }

    private static class FilteredCollector<D extends CallableDescriptor>
    implements CallableDescriptorCollector<D> {
        private final CallableDescriptorCollector<D> delegate;

        private FilteredCollector(CallableDescriptorCollector<D> delegate) {
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public Collection<D> getNonExtensionsByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getNonExtensionsByName"));
            }
            List<D> list2 = LibrarySourceHacks.filterOutMembersFromLibrarySource(this.delegate.getNonExtensionsByName(scope, name, bindingTrace), bindingTrace);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getNonExtensionsByName"));
            }
            return list2;
        }

        @Override
        @NotNull
        public Collection<D> getMembersByName(@NotNull JetType receiver, Name name, @NotNull BindingTrace bindingTrace) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getMembersByName"));
            }
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getMembersByName"));
            }
            List<D> list2 = LibrarySourceHacks.filterOutMembersFromLibrarySource(this.delegate.getMembersByName(receiver, name, bindingTrace), bindingTrace);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getMembersByName"));
            }
            return list2;
        }

        @Override
        @NotNull
        public Collection<D> getNonMembersByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getNonMembersByName"));
            }
            List<D> list2 = LibrarySourceHacks.filterOutMembersFromLibrarySource(this.delegate.getNonMembersByName(scope, name, bindingTrace), bindingTrace);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getNonMembersByName"));
            }
            return list2;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class PropertyCollector
    implements CallableDescriptorCollector<VariableDescriptor> {
        private PropertyCollector() {
        }

        private static Collection<VariableDescriptor> filterProperties(Collection<? extends VariableDescriptor> variableDescriptors) {
            ArrayList<VariableDescriptor> properties = Lists.newArrayList();
            for (VariableDescriptor variableDescriptor : variableDescriptors) {
                if (!(variableDescriptor instanceof PropertyDescriptor)) continue;
                properties.add(variableDescriptor);
            }
            return properties;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonExtensionsByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getNonExtensionsByName"));
            }
            Collection<VariableDescriptor> collection = PropertyCollector.filterProperties(VARIABLES.getNonExtensionsByName(scope, name, bindingTrace));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getNonExtensionsByName"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getMembersByName(@NotNull JetType receiver, Name name, @NotNull BindingTrace bindingTrace) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getMembersByName"));
            }
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getMembersByName"));
            }
            Collection<VariableDescriptor> collection = PropertyCollector.filterProperties(VARIABLES.getMembersByName(receiver, name, bindingTrace));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getMembersByName"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonMembersByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getNonMembersByName"));
            }
            Collection<VariableDescriptor> collection = PropertyCollector.filterProperties(VARIABLES.getNonMembersByName(scope, name, bindingTrace));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getNonMembersByName"));
            }
            return collection;
        }

        public String toString() {
            return "PROPERTIES";
        }
    }

    private static class VariableCollector
    implements CallableDescriptorCollector<VariableDescriptor> {
        private VariableCollector() {
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonExtensionsByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getNonExtensionsByName"));
            }
            VariableDescriptor localVariable = scope.getLocalVariable(name);
            if (localVariable != null) {
                Set<VariableDescriptor> set2 = Collections.singleton(localVariable);
                if (set2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getNonExtensionsByName"));
                }
                return set2;
            }
            LinkedHashSet<VariableDescriptor> variables = Sets.newLinkedHashSet();
            for (VariableDescriptor variable : scope.getProperties(name)) {
                if (variable.getReceiverParameter() != null) continue;
                variables.add(variable);
            }
            LinkedHashSet<VariableDescriptor> linkedHashSet = variables;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getNonExtensionsByName"));
            }
            return linkedHashSet;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getMembersByName(@NotNull JetType receiverType, Name name, @NotNull BindingTrace bindingTrace) {
            if (receiverType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getMembersByName"));
            }
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getMembersByName"));
            }
            Collection<VariableDescriptor> collection = receiverType.getMemberScope().getProperties(name);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getMembersByName"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonMembersByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getNonMembersByName"));
            }
            LinkedHashSet<VariableDescriptor> result = Sets.newLinkedHashSet();
            VariableDescriptor localVariable = scope.getLocalVariable(name);
            if (localVariable != null) {
                result.add(localVariable);
            }
            result.addAll(scope.getProperties(name));
            LinkedHashSet<VariableDescriptor> linkedHashSet = result;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getNonMembersByName"));
            }
            return linkedHashSet;
        }

        public String toString() {
            return "VARIABLES";
        }
    }

    private static class FunctionCollector
    implements CallableDescriptorCollector<FunctionDescriptor> {
        private FunctionCollector() {
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getNonExtensionsByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getNonExtensionsByName"));
            }
            LinkedHashSet<FunctionDescriptor> functions = Sets.newLinkedHashSet();
            for (FunctionDescriptor function : scope.getFunctions(name)) {
                if (function.getReceiverParameter() != null) continue;
                functions.add(function);
            }
            FunctionCollector.addConstructors(scope, name, functions);
            LinkedHashSet<FunctionDescriptor> linkedHashSet = functions;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getNonExtensionsByName"));
            }
            return linkedHashSet;
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getMembersByName(@NotNull JetType receiverType, Name name, @NotNull BindingTrace bindingTrace) {
            if (receiverType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getMembersByName"));
            }
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getMembersByName"));
            }
            JetScope receiverScope = receiverType.getMemberScope();
            HashSet<FunctionDescriptor> members = Sets.newHashSet(receiverScope.getFunctions(name));
            FunctionCollector.addConstructors(receiverScope, name, members);
            HashSet<FunctionDescriptor> hashSet = members;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getMembersByName"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getNonMembersByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getNonMembersByName"));
            }
            Collection<FunctionDescriptor> collection = scope.getFunctions(name);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getNonMembersByName"));
            }
            return collection;
        }

        private static void addConstructors(JetScope scope, Name name, Collection<FunctionDescriptor> functions) {
            ClassifierDescriptor classifier = scope.getClassifier(name);
            if (classifier instanceof ClassDescriptor && !ErrorUtils.isError(classifier)) {
                functions.addAll(((ClassDescriptor)classifier).getConstructors());
            }
        }

        public String toString() {
            return "FUNCTIONS";
        }
    }
}

