/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.stubs.PsiJetObjectStub;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiJetObjectStubImpl
extends StubBase<JetObjectDeclaration>
implements PsiJetObjectStub {
    private final StringRef name;
    private final FqName fqName;
    private final boolean isTopLevel;
    private final boolean isClassObject;

    public PsiJetObjectStubImpl(@NotNull IStubElementType elementType, @NotNull StubElement parent, @Nullable String name, @Nullable FqName fqName, boolean isTopLevel, boolean isClassObject) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetObjectStubImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetObjectStubImpl", "<init>"));
        }
        this(elementType, parent, StringRef.fromString(name), fqName, isTopLevel, isClassObject);
    }

    public PsiJetObjectStubImpl(@NotNull IStubElementType elementType, @NotNull StubElement parent, @Nullable StringRef name, @Nullable FqName fqName, boolean isTopLevel, boolean isClassObject) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetObjectStubImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetObjectStubImpl", "<init>"));
        }
        super(parent, elementType);
        this.name = name;
        this.fqName = fqName;
        this.isTopLevel = isTopLevel;
        this.isClassObject = isClassObject;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }

    @Override
    @Nullable
    public FqName getFqName() {
        return this.fqName;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public boolean isClassObject() {
        return this.isClassObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiJetObjectStubImpl[");
        if (this.isClassObject) {
            builder.append("class-object ");
        }
        if (this.isTopLevel) {
            builder.append("top ");
        }
        builder.append("name=").append(this.getName());
        builder.append(" fqName=").append(this.fqName != null ? this.fqName.toString() : "null");
        builder.append("]");
        return builder.toString();
    }
}

