/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetAnnotation;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetToken;

public class JetModifierList
extends JetElementImpl {
    public JetModifierList(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetModifierList", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetModifierList", "accept"));
        }
        visitor.visitModifierList(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetModifierList", "accept"));
        }
        return visitor.visitModifierList(this, data);
    }

    @NotNull
    public List<JetAnnotation> getAnnotations() {
        List<JetAnnotation> list2 = this.findChildrenByType(JetNodeTypes.ANNOTATION);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetModifierList", "getAnnotations"));
        }
        return list2;
    }

    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        List entries = this.findChildrenByType(JetNodeTypes.ANNOTATION_ENTRY);
        ArrayList<Object> answer = entries.isEmpty() ? null : Lists.newArrayList(entries);
        for (JetAnnotation annotation : this.getAnnotations()) {
            if (answer == null) {
                answer = new ArrayList();
            }
            answer.addAll(annotation.getEntries());
        }
        List list2 = answer != null ? answer : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetModifierList", "getAnnotationEntries"));
        }
        return list2;
    }

    @NotNull
    public List<ASTNode> getModifierNodes() {
        ArrayList<ASTNode> modifierNodes = new ArrayList<ASTNode>();
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            if (!(node.getElementType() instanceof JetKeywordToken)) continue;
            modifierNodes.add(node);
        }
        ArrayList<ASTNode> arrayList = modifierNodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetModifierList", "getModifierNodes"));
        }
        return arrayList;
    }

    public boolean hasModifier(JetToken token) {
        return this.getModifierNode(token) != null;
    }

    @Nullable
    public PsiElement getModifier(JetToken token) {
        return this.findChildByType(token);
    }

    @Nullable
    public ASTNode getModifierNode(JetToken token) {
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            if (node.getElementType() != token) continue;
            return node;
        }
        return null;
    }
}

