/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetAnnotation;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElementImplStub;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lexer.JetToken;

abstract class JetDeclarationStub<T extends StubElement>
extends JetElementImplStub<T>
implements JetDeclaration {
    public JetDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "<init>"));
        }
        super(stub, nodeType);
    }

    public JetDeclarationStub(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        return (JetModifierList)this.findChildByType(JetNodeTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifier(JetToken modifier) {
        JetModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(modifier);
    }

    @Override
    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<JetAnnotationEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "getAnnotationEntries"));
            }
            return list2;
        }
        List<JetAnnotationEntry> list3 = modifierList.getAnnotationEntries();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "getAnnotationEntries"));
        }
        return list3;
    }

    @Override
    @NotNull
    public List<JetAnnotation> getAnnotations() {
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<JetAnnotation> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "getAnnotations"));
            }
            return list2;
        }
        List<JetAnnotation> list3 = modifierList.getAnnotations();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "getAnnotations"));
        }
        return list3;
    }
}

