/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.SubstitutingScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;

public class ClassDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements ClassDescriptor {
    private TypeConstructor typeConstructor;
    private JetScope memberDeclarations;
    private Set<ConstructorDescriptor> constructors;
    private ConstructorDescriptor primaryConstructor;
    private ReceiverParameterDescriptor thisAsReceiverParameter;
    private final Modality modality;
    private ClassDescriptor classObjectDescriptor;
    private final ClassKind kind;
    private boolean isInner;

    public ClassDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Modality modality, @NotNull Name name) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        this(containingDeclaration, ClassKind.CLASS, annotations, modality, name);
    }

    public ClassDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull ClassKind kind, @NotNull List<AnnotationDescriptor> annotations, @NotNull Modality modality, @NotNull Name name) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations, name);
        this.kind = kind;
        this.modality = modality;
    }

    public final ClassDescriptorImpl initialize(boolean sealed, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull Collection<JetType> supertypes, @NotNull JetScope memberDeclarations, @NotNull Set<ConstructorDescriptor> constructors, @Nullable ConstructorDescriptor primaryConstructor, boolean isInner) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "initialize"));
        }
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "initialize"));
        }
        if (memberDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "initialize"));
        }
        if (constructors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "initialize"));
        }
        this.typeConstructor = new TypeConstructorImpl(this, this.getAnnotations(), sealed, this.getName().asString(), typeParameters, supertypes);
        this.memberDeclarations = memberDeclarations;
        this.constructors = constructors;
        this.primaryConstructor = primaryConstructor;
        this.isInner = isInner;
        return this;
    }

    public void setPrimaryConstructor(@NotNull ConstructorDescriptor primaryConstructor) {
        if (primaryConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "setPrimaryConstructor"));
        }
        this.primaryConstructor = primaryConstructor;
    }

    public void setClassObjectDescriptor(@NotNull ClassDescriptor classObjectDescriptor) {
        if (classObjectDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "setClassObjectDescriptor"));
        }
        this.classObjectDescriptor = classObjectDescriptor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor = this.typeConstructor;
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "getTypeConstructor"));
        }
        return typeConstructor;
    }

    @Override
    @NotNull
    public JetScope getMemberScope(List<TypeProjection> typeArguments) {
        assert (typeArguments.size() == this.typeConstructor.getParameters().size()) : typeArguments;
        if (this.typeConstructor.getParameters().isEmpty()) {
            JetScope jetScope = this.memberDeclarations;
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "getMemberScope"));
            }
            return jetScope;
        }
        Map<TypeConstructor, TypeProjection> substitutionContext = SubstitutionUtils.buildSubstitutionContext(this.typeConstructor.getParameters(), typeArguments);
        SubstitutingScope substitutingScope = new SubstitutingScope(this.memberDeclarations, TypeSubstitutor.create(substitutionContext));
        if (substitutingScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "getMemberScope"));
        }
        return substitutingScope;
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        JetType jetType = TypeUtils.makeUnsubstitutedType(this, this.memberDeclarations);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "getDefaultType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Set<ConstructorDescriptor> set2 = this.constructors;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "getConstructors"));
        }
        return set2;
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "substitute"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public JetType getClassObjectType() {
        return this.getClassObjectDescriptor().getDefaultType();
    }

    @Override
    public ClassDescriptor getClassObjectDescriptor() {
        return this.classObjectDescriptor;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "getKind"));
        }
        return classKind;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitClassDescriptor(this, data);
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = Visibilities.PUBLIC;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        if (this.thisAsReceiverParameter == null) {
            this.thisAsReceiverParameter = DescriptorFactory.createLazyReceiverParameterDescriptor(this);
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = this.thisAsReceiverParameter;
        if (receiverParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "getThisAsReceiverParameter"));
        }
        return receiverParameterDescriptor;
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        JetScope jetScope = JetScope.EMPTY;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ClassDescriptorImpl", "getUnsubstitutedInnerClassesScope"));
        }
        return jetScope;
    }
}

