/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;

public abstract class AbstractLazyTypeParameterDescriptor
implements TypeParameterDescriptor {
    private final Variance variance;
    private final boolean reified;
    private final int index;
    private final DeclarationDescriptor containingDeclaration;
    private final Name name;
    private final NotNullLazyValue<TypeConstructor> typeConstructor;
    private final NotNullLazyValue<JetType> defaultType;
    private final NotNullLazyValue<Set<JetType>> upperBounds;
    private final NotNullLazyValue<JetType> upperBoundsAsType;

    public AbstractLazyTypeParameterDescriptor(final @NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull Variance variance, boolean isReified, int index) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "<init>"));
        }
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "<init>"));
        }
        this.variance = variance;
        this.containingDeclaration = containingDeclaration;
        this.index = index;
        this.name = name;
        this.reified = isReified;
        this.typeConstructor = storageManager.createLazyValue(new Function0<TypeConstructor>(){

            @Override
            public TypeConstructor invoke() {
                return AbstractLazyTypeParameterDescriptor.this.createTypeConstructor();
            }
        });
        this.defaultType = storageManager.createLazyValue(new Function0<JetType>(){

            @Override
            public JetType invoke() {
                return AbstractLazyTypeParameterDescriptor.this.createDefaultType(storageManager);
            }
        });
        this.upperBounds = storageManager.createLazyValue(new Function0<Set<JetType>>(){

            @Override
            public Set<JetType> invoke() {
                return AbstractLazyTypeParameterDescriptor.this.resolveUpperBounds();
            }
        });
        this.upperBoundsAsType = storageManager.createLazyValue(new Function0<JetType>(){

            @Override
            public JetType invoke() {
                return AbstractLazyTypeParameterDescriptor.this.computeUpperBoundsAsType();
            }
        });
    }

    @Override
    public boolean isReified() {
        return this.reified;
    }

    @Override
    @NotNull
    public Variance getVariance() {
        Variance variance = this.variance;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "getVariance"));
        }
        return variance;
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        Set<JetType> set2 = this.upperBounds.invoke();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "getUpperBounds"));
        }
        return set2;
    }

    @NotNull
    protected abstract Set<JetType> resolveUpperBounds();

    @Override
    @NotNull
    public JetType getUpperBoundsAsType() {
        JetType jetType = this.upperBoundsAsType.invoke();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "getUpperBoundsAsType"));
        }
        return jetType;
    }

    @NotNull
    private JetType computeUpperBoundsAsType() {
        Set<JetType> upperBounds = this.getUpperBounds();
        assert (upperBounds.size() > 0) : "Upper bound list is empty in " + this.getName();
        JetType upperBoundsAsType = TypeUtils.intersect(JetTypeChecker.INSTANCE, upperBounds);
        if (upperBoundsAsType == null) {
            upperBoundsAsType = KotlinBuiltIns.getInstance().getNothingType();
        }
        JetType jetType = upperBoundsAsType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "computeUpperBoundsAsType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        Set<JetType> set2 = Collections.singleton(this.getLowerBoundsAsType());
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "getLowerBounds"));
        }
        return set2;
    }

    @Override
    @NotNull
    public JetType getLowerBoundsAsType() {
        JetType jetType = KotlinBuiltIns.getInstance().getNothingType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "getLowerBoundsAsType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor = this.typeConstructor.invoke();
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "getTypeConstructor"));
        }
        return typeConstructor;
    }

    @NotNull
    private TypeConstructor createTypeConstructor() {
        TypeConstructor typeConstructor = new TypeConstructor(){

            @Override
            @NotNull
            public Collection<JetType> getSupertypes() {
                Set<JetType> set2 = AbstractLazyTypeParameterDescriptor.this.getUpperBounds();
                if (set2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor$5", "getSupertypes"));
                }
                return set2;
            }

            @Override
            @NotNull
            public List<TypeParameterDescriptor> getParameters() {
                List<TypeParameterDescriptor> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor$5", "getParameters"));
                }
                return list2;
            }

            @Override
            public boolean isSealed() {
                return false;
            }

            @Override
            public boolean isDenotable() {
                return true;
            }

            @Override
            public ClassifierDescriptor getDeclarationDescriptor() {
                return AbstractLazyTypeParameterDescriptor.this;
            }

            @Override
            public List<AnnotationDescriptor> getAnnotations() {
                return AbstractLazyTypeParameterDescriptor.this.getAnnotations();
            }

            public String toString() {
                return AbstractLazyTypeParameterDescriptor.this.getName().toString();
            }
        };
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "createTypeConstructor"));
        }
        return typeConstructor;
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        JetType jetType = this.defaultType.invoke();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "getDefaultType"));
        }
        return jetType;
    }

    @NotNull
    private JetType createDefaultType(@NotNull StorageManager storageManager) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "createDefaultType"));
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(this.getTypeConstructor(), new LazyScopeAdapter(storageManager.createLazyValue(new Function0<JetScope>(){

            @Override
            public JetScope invoke() {
                return AbstractLazyTypeParameterDescriptor.this.getUpperBoundsAsType().getMemberScope();
            }
        })));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "createDefaultType"));
        }
        return jetTypeImpl;
    }

    @Override
    public JetType getClassObjectType() {
        return null;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        AbstractLazyTypeParameterDescriptor abstractLazyTypeParameterDescriptor = this;
        if (abstractLazyTypeParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "getOriginal"));
        }
        return abstractLazyTypeParameterDescriptor;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.containingDeclaration;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @Deprecated
    @NotNull
    public TypeParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "substitute"));
        }
        throw new UnsupportedOperationException("Don't call substitute() on type parameters");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitTypeParameterDescriptor(this, data);
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        visitor.visitTypeParameterDescriptor(this, null);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = this.name;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractLazyTypeParameterDescriptor", "getName"));
        }
        return name;
    }

    public String toString() {
        try {
            return DescriptorRenderer.DEBUG_TEXT.render(this);
        }
        catch (Exception e) {
            return this.getClass().getName() + "@" + System.identityHashCode(this);
        }
    }
}

