/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.psi.JetElement;

public class SubroutineExitInstruction
extends InstructionImpl {
    private final JetElement subroutine;
    private final String debugLabel;
    private SubroutineSinkInstruction sinkInstruction;

    public SubroutineExitInstruction(@NotNull JetElement subroutine, @NotNull String debugLabel) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineExitInstruction", "<init>"));
        }
        if (debugLabel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineExitInstruction", "<init>"));
        }
        this.subroutine = subroutine;
        this.debugLabel = debugLabel;
    }

    public JetElement getSubroutine() {
        return this.subroutine;
    }

    public void setSink(SubroutineSinkInstruction instruction) {
        this.sinkInstruction = (SubroutineSinkInstruction)this.outgoingEdgeTo(instruction);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        assert (this.sinkInstruction != null);
        Set<Instruction> set2 = Collections.singleton(this.sinkInstruction);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineExitInstruction", "getNextInstructions"));
        }
        return set2;
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitSubroutineExit(this);
    }

    public String toString() {
        return this.debugLabel;
    }

    @Override
    protected Instruction createCopy() {
        return new SubroutineExitInstruction(this.subroutine, this.debugLabel);
    }
}

