/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;

public abstract class AbstractJumpInstruction
extends InstructionImpl {
    private final Label targetLabel;
    private Instruction resolvedTarget;

    public AbstractJumpInstruction(Label targetLabel) {
        this.targetLabel = targetLabel;
    }

    public Label getTargetLabel() {
        return this.targetLabel;
    }

    public Instruction getResolvedTarget() {
        return this.resolvedTarget;
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        Set<Instruction> set2 = Collections.singleton(this.getResolvedTarget());
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/AbstractJumpInstruction", "getNextInstructions"));
        }
        return set2;
    }

    public void setResolvedTarget(Instruction resolvedTarget) {
        this.resolvedTarget = this.outgoingEdgeTo(resolvedTarget);
    }

    protected abstract AbstractJumpInstruction createCopy(@NotNull Label var1);

    public final Instruction copy(@NotNull Label newLabel) {
        if (newLabel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/cfg/pseudocode/AbstractJumpInstruction", "copy"));
        }
        return this.updateCopyInfo(this.createCopy(newLabel));
    }

    @Override
    protected Instruction createCopy() {
        return this.createCopy(this.targetLabel);
    }
}

