/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.di;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinderImpl;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationArgumentResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaConstructorResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaFunctionResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaNamespaceResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaPropertyResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSupertypeResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeParameterResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaValueParameterResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PsiBasedExternalAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PsiBasedMethodSignatureChecker;
import org.jetbrains.jet.lang.resolve.java.resolver.TraceBasedErrorReporter;
import org.jetbrains.jet.lang.resolve.java.resolver.TraceBasedExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TraceBasedJavaResolverCache;
import org.jetbrains.jet.lang.resolve.kotlin.AnnotationDescriptorDeserializer;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileKotlinClassFinder;

public class InjectorForJavaDescriptorResolver {
    private final Project project;
    private final BindingTrace bindingTrace;
    private final JavaClassFinderImpl javaClassFinder;
    private final TraceBasedExternalSignatureResolver traceBasedExternalSignatureResolver;
    private final TraceBasedJavaResolverCache traceBasedJavaResolverCache;
    private final TraceBasedErrorReporter traceBasedErrorReporter;
    private final PsiBasedMethodSignatureChecker psiBasedMethodSignatureChecker;
    private final PsiBasedExternalAnnotationResolver psiBasedExternalAnnotationResolver;
    private final JavaDescriptorResolver javaDescriptorResolver;
    private final VirtualFileKotlinClassFinder virtualFileKotlinClassFinder;
    private final VirtualFileFinder virtualFileFinder;
    private final JavaAnnotationResolver javaAnnotationResolver;
    private final JavaAnnotationArgumentResolver javaAnnotationArgumentResolver;
    private final JavaClassResolver javaClassResolver;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;
    private final AnnotationDescriptorDeserializer annotationDescriptorDeserializer;
    private final JavaNamespaceResolver javaNamespaceResolver;
    private final JavaMemberResolver javaMemberResolver;
    private final JavaConstructorResolver javaConstructorResolver;
    private final JavaTypeTransformer javaTypeTransformer;
    private final JavaValueParameterResolver javaValueParameterResolver;
    private final JavaFunctionResolver javaFunctionResolver;
    private final JavaTypeParameterResolver javaTypeParameterResolver;
    private final JavaPropertyResolver javaPropertyResolver;
    private final JavaSupertypeResolver javaSupertypeResolver;

    public InjectorForJavaDescriptorResolver(@NotNull Project project, @NotNull BindingTrace bindingTrace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/di/InjectorForJavaDescriptorResolver", "<init>"));
        }
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/di/InjectorForJavaDescriptorResolver", "<init>"));
        }
        this.project = project;
        this.bindingTrace = bindingTrace;
        this.javaClassFinder = new JavaClassFinderImpl();
        this.traceBasedExternalSignatureResolver = new TraceBasedExternalSignatureResolver();
        this.traceBasedJavaResolverCache = new TraceBasedJavaResolverCache();
        this.traceBasedErrorReporter = new TraceBasedErrorReporter();
        this.psiBasedMethodSignatureChecker = new PsiBasedMethodSignatureChecker();
        this.psiBasedExternalAnnotationResolver = new PsiBasedExternalAnnotationResolver();
        this.javaDescriptorResolver = new JavaDescriptorResolver();
        this.virtualFileKotlinClassFinder = new VirtualFileKotlinClassFinder();
        this.virtualFileFinder = ServiceManager.getService(project, VirtualFileFinder.class);
        this.javaAnnotationResolver = new JavaAnnotationResolver();
        this.javaAnnotationArgumentResolver = new JavaAnnotationArgumentResolver();
        this.javaClassResolver = new JavaClassResolver();
        this.deserializedDescriptorResolver = new DeserializedDescriptorResolver();
        this.annotationDescriptorDeserializer = new AnnotationDescriptorDeserializer();
        this.javaNamespaceResolver = new JavaNamespaceResolver();
        this.javaMemberResolver = new JavaMemberResolver();
        this.javaConstructorResolver = new JavaConstructorResolver();
        this.javaTypeTransformer = new JavaTypeTransformer();
        this.javaValueParameterResolver = new JavaValueParameterResolver();
        this.javaFunctionResolver = new JavaFunctionResolver();
        this.javaTypeParameterResolver = new JavaTypeParameterResolver();
        this.javaPropertyResolver = new JavaPropertyResolver();
        this.javaSupertypeResolver = new JavaSupertypeResolver();
        this.javaClassFinder.setProject(project);
        this.traceBasedExternalSignatureResolver.setAnnotationResolver(this.javaAnnotationResolver);
        this.traceBasedExternalSignatureResolver.setTrace(bindingTrace);
        this.traceBasedJavaResolverCache.setTrace(bindingTrace);
        this.traceBasedErrorReporter.setTrace(bindingTrace);
        this.psiBasedMethodSignatureChecker.setAnnotationResolver(this.javaAnnotationResolver);
        this.psiBasedMethodSignatureChecker.setExternalSignatureResolver(this.traceBasedExternalSignatureResolver);
        this.javaDescriptorResolver.setClassResolver(this.javaClassResolver);
        this.javaDescriptorResolver.setNamespaceResolver(this.javaNamespaceResolver);
        this.virtualFileKotlinClassFinder.setVirtualFileFinder(this.virtualFileFinder);
        this.javaAnnotationResolver.setArgumentResolver(this.javaAnnotationArgumentResolver);
        this.javaAnnotationResolver.setClassResolver(this.javaClassResolver);
        this.javaAnnotationResolver.setExternalAnnotationResolver(this.psiBasedExternalAnnotationResolver);
        this.javaAnnotationArgumentResolver.setAnnotationResolver(this.javaAnnotationResolver);
        this.javaAnnotationArgumentResolver.setClassResolver(this.javaClassResolver);
        this.javaAnnotationArgumentResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaClassResolver.setAnnotationResolver(this.javaAnnotationResolver);
        this.javaClassResolver.setCache(this.traceBasedJavaResolverCache);
        this.javaClassResolver.setDeserializedDescriptorResolver(this.deserializedDescriptorResolver);
        this.javaClassResolver.setFunctionResolver(this.javaFunctionResolver);
        this.javaClassResolver.setJavaClassFinder(this.javaClassFinder);
        this.javaClassResolver.setKotlinClassFinder(this.virtualFileKotlinClassFinder);
        this.javaClassResolver.setMemberResolver(this.javaMemberResolver);
        this.javaClassResolver.setNamespaceResolver(this.javaNamespaceResolver);
        this.javaClassResolver.setSupertypesResolver(this.javaSupertypeResolver);
        this.javaClassResolver.setTypeParameterResolver(this.javaTypeParameterResolver);
        this.deserializedDescriptorResolver.setAnnotationDeserializer(this.annotationDescriptorDeserializer);
        this.deserializedDescriptorResolver.setErrorReporter(this.traceBasedErrorReporter);
        this.deserializedDescriptorResolver.setJavaClassResolver(this.javaClassResolver);
        this.deserializedDescriptorResolver.setJavaNamespaceResolver(this.javaNamespaceResolver);
        this.annotationDescriptorDeserializer.setErrorReporter(this.traceBasedErrorReporter);
        this.annotationDescriptorDeserializer.setJavaClassResolver(this.javaClassResolver);
        this.annotationDescriptorDeserializer.setKotlinClassFinder(this.virtualFileKotlinClassFinder);
        this.javaNamespaceResolver.setCache(this.traceBasedJavaResolverCache);
        this.javaNamespaceResolver.setDeserializedDescriptorResolver(this.deserializedDescriptorResolver);
        this.javaNamespaceResolver.setJavaClassFinder(this.javaClassFinder);
        this.javaNamespaceResolver.setKotlinClassFinder(this.virtualFileKotlinClassFinder);
        this.javaNamespaceResolver.setMemberResolver(this.javaMemberResolver);
        this.javaMemberResolver.setClassResolver(this.javaClassResolver);
        this.javaMemberResolver.setConstructorResolver(this.javaConstructorResolver);
        this.javaMemberResolver.setFunctionResolver(this.javaFunctionResolver);
        this.javaMemberResolver.setNamespaceResolver(this.javaNamespaceResolver);
        this.javaMemberResolver.setPropertyResolver(this.javaPropertyResolver);
        this.javaConstructorResolver.setCache(this.traceBasedJavaResolverCache);
        this.javaConstructorResolver.setExternalSignatureResolver(this.traceBasedExternalSignatureResolver);
        this.javaConstructorResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaConstructorResolver.setValueParameterResolver(this.javaValueParameterResolver);
        this.javaTypeTransformer.setClassResolver(this.javaClassResolver);
        this.javaValueParameterResolver.setAnnotationResolver(this.javaAnnotationResolver);
        this.javaValueParameterResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaFunctionResolver.setAnnotationResolver(this.javaAnnotationResolver);
        this.javaFunctionResolver.setCache(this.traceBasedJavaResolverCache);
        this.javaFunctionResolver.setErrorReporter(this.traceBasedErrorReporter);
        this.javaFunctionResolver.setExternalSignatureResolver(this.traceBasedExternalSignatureResolver);
        this.javaFunctionResolver.setSignatureChecker(this.psiBasedMethodSignatureChecker);
        this.javaFunctionResolver.setTypeParameterResolver(this.javaTypeParameterResolver);
        this.javaFunctionResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaFunctionResolver.setValueParameterResolver(this.javaValueParameterResolver);
        this.javaTypeParameterResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaPropertyResolver.setAnnotationResolver(this.javaAnnotationResolver);
        this.javaPropertyResolver.setCache(this.traceBasedJavaResolverCache);
        this.javaPropertyResolver.setErrorReporter(this.traceBasedErrorReporter);
        this.javaPropertyResolver.setExternalSignatureResolver(this.traceBasedExternalSignatureResolver);
        this.javaPropertyResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaSupertypeResolver.setClassResolver(this.javaClassResolver);
        this.javaSupertypeResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaClassFinder.initialize();
    }

    @PreDestroy
    public void destroy() {
    }

    public JavaClassFinderImpl getJavaClassFinder() {
        return this.javaClassFinder;
    }

    public JavaDescriptorResolver getJavaDescriptorResolver() {
        return this.javaDescriptorResolver;
    }
}

