/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class BitEncoding {
    private BitEncoding() {
    }

    @NotNull
    public static String[] encodeBytes(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "encodeBytes"));
        }
        byte[] bytes = BitEncoding.encode8to7(data);
        BitEncoding.addModuloByte(bytes, 1);
        String[] stringArray = BitEncoding.splitBytesToStringArray(bytes);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "encodeBytes"));
        }
        return stringArray;
    }

    @NotNull
    private static byte[] encode8to7(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "encode8to7"));
        }
        int resultLength = (data.length * 8 + 6) / 7;
        byte[] result = new byte[resultLength];
        int byteIndex = 0;
        int bit = 0;
        for (int i = 0; i < resultLength - 1; ++i) {
            if (bit == 0) {
                result[i] = (byte)(data[byteIndex] & 0x7F);
                bit = 7;
                continue;
            }
            int firstPart = (data[byteIndex] & 0xFF) >>> bit;
            int newBit = bit + 7 & 7;
            int secondPart = (data[++byteIndex] & (1 << newBit) - 1) << 8 - bit;
            result[i] = (byte)(firstPart + secondPart);
            bit = newBit;
        }
        if (resultLength > 0) {
            assert (bit != 0) : "The last chunk cannot start from the input byte since otherwise at least one bit will remain unprocessed";
            assert (byteIndex == data.length - 1) : "The last 7-bit chunk should be encoded from the last input byte: " + byteIndex + " != " + (data.length - 1);
            result[resultLength - 1] = (byte)((data[byteIndex] & 0xFF) >>> bit);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "encode8to7"));
        }
        return result;
    }

    private static void addModuloByte(@NotNull byte[] data, int increment) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "addModuloByte"));
        }
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = (byte)(data[i] + increment & 0x7F);
        }
    }

    @NotNull
    private static String[] splitBytesToStringArray(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "splitBytesToStringArray"));
        }
        ArrayList<String> result = new ArrayList<String>();
        int off = 0;
        int len = 0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (len >= 65534) {
                assert (len <= 65535) : "Produced strings cannot contain more than 65535 bytes: " + len;
                result.add(new String(data, off, i - off));
                off = i;
                len = 0;
            }
            if (data[i] == 0) {
                len += 2;
                continue;
            }
            ++len;
        }
        if (len >= 0) {
            result.add(new String(data, off, data.length - off));
        }
        String[] stringArray = result.toArray(new String[result.size()]);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "splitBytesToStringArray"));
        }
        return stringArray;
    }

    @NotNull
    public static byte[] decodeBytes(@NotNull String[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "decodeBytes"));
        }
        byte[] bytes = BitEncoding.combineStringArrayIntoBytes(data);
        BitEncoding.addModuloByte(bytes, 127);
        byte[] byArray = BitEncoding.decode7to8(bytes);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "decodeBytes"));
        }
        return byArray;
    }

    @NotNull
    private static byte[] combineStringArrayIntoBytes(@NotNull String[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "combineStringArrayIntoBytes"));
        }
        int resultLength = 0;
        for (String s : data) {
            assert (s.length() <= 65535) : "Too long string: " + s.length();
            resultLength += s.length();
        }
        byte[] result = new byte[resultLength];
        int p = 0;
        for (String s : data) {
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                result[p++] = (byte)s.charAt(i);
            }
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "combineStringArrayIntoBytes"));
        }
        return result;
    }

    @NotNull
    private static byte[] decode7to8(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "decode7to8"));
        }
        int resultLength = 7 * data.length / 8;
        byte[] result = new byte[resultLength];
        int byteIndex = 0;
        int bit = 0;
        for (int i = 0; i < resultLength; ++i) {
            int firstPart = (data[byteIndex] & 0xFF) >>> bit;
            int secondPart = (data[++byteIndex] & (1 << bit + 1) - 1) << 7 - bit;
            result[i] = (byte)(firstPart + secondPart);
            if (bit == 6) {
                ++byteIndex;
                bit = 0;
                continue;
            }
            ++bit;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/BitEncoding", "decode7to8"));
        }
        return result;
    }
}

