/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.google.common.base.Predicates;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jet.Function0;
import jet.modules.AllModules;
import jet.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.CompilerPlugin;
import org.jetbrains.jet.cli.common.CompilerPluginContext;
import org.jetbrains.jet.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.cli.common.messages.MessageUtil;
import org.jetbrains.jet.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.ChunkAsOneModule;
import org.jetbrains.jet.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.compiler.ModuleChunk;
import org.jetbrains.jet.codegen.ClassBuilderFactories;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.GeneratedClassLoader;
import org.jetbrains.jet.codegen.KotlinCodegenFacade;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.Progress;
import org.jetbrains.jet.config.CommonConfigurationKeys;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.lang.parsing.JetScriptDefinition;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.JetMainDetector;
import org.jetbrains.jet.utils.ExceptionUtils;
import org.jetbrains.jet.utils.KotlinPaths;
import org.jetbrains.jet.utils.PathUtil;

public class KotlinToJVMBytecodeCompiler {
    private KotlinToJVMBytecodeCompiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ClassFileFactory compileModule(CompilerConfiguration configuration, Module module, File directory) {
        List<String> sourceFiles = module.getSourceFiles();
        if (sourceFiles.isEmpty()) {
            throw new CompileEnvironmentException("No source files where defined in module " + module.getModuleName());
        }
        CompilerConfiguration compilerConfiguration = configuration.copy();
        for (String sourceFile : sourceFiles) {
            File source = new File(sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, sourceFile);
            }
            if (!source.exists()) {
                throw new CompileEnvironmentException("'" + source + "' does not exist in module " + module.getModuleName());
            }
            compilerConfiguration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, source.getPath());
        }
        for (String classpathRoot : module.getClasspathRoots()) {
            compilerConfiguration.add(JVMConfigurationKeys.CLASSPATH_KEY, new File(classpathRoot));
        }
        for (String annotationsRoot : module.getAnnotationsRoots()) {
            compilerConfiguration.add(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, new File(annotationsRoot));
        }
        Disposable parentDisposable = CompileEnvironmentUtil.createMockDisposable();
        JetCoreEnvironment moduleEnvironment = null;
        try {
            moduleEnvironment = new JetCoreEnvironment(parentDisposable, compilerConfiguration);
            GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(moduleEnvironment);
            if (generationState == null) {
                ClassFileFactory classFileFactory = null;
                return classFileFactory;
            }
            ClassFileFactory classFileFactory = generationState.getFactory();
            return classFileFactory;
        }
        finally {
            if (moduleEnvironment != null) {
                Disposer.dispose(parentDisposable);
            }
        }
    }

    private static void writeOutput(CompilerConfiguration configuration, ClassFileFactory moduleFactory, CompileEnvironmentUtil.OutputDirector outputDir, File jarPath, boolean jarRuntime, FqName mainClass) {
        MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
        CompileEnvironmentUtil.writeOutputToDirOrJar(jarPath, outputDir, jarRuntime, mainClass, moduleFactory, messageCollector);
    }

    public static boolean compileModules(CompilerConfiguration configuration, final @NotNull ModuleChunk chunk, @NotNull File directory, @Nullable File jarPath, boolean jarRuntime) {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        List<Module> modules = chunk.getModules();
        if (modules.size() > 1) {
            modules = Collections.singletonList(new ChunkAsOneModule(chunk));
        }
        for (Module module : modules) {
            ClassFileFactory moduleFactory = KotlinToJVMBytecodeCompiler.compileModule(configuration, module, directory);
            if (moduleFactory == null) {
                return false;
            }
            CompileEnvironmentUtil.OutputDirector outputDir = new CompileEnvironmentUtil.OutputDirector(){

                @Override
                @NotNull
                public File getOutputDirectory(@NotNull Collection<File> sourceFiles) {
                    if (sourceFiles == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$1", "getOutputDirectory"));
                    }
                    for (File sourceFile : sourceFiles) {
                        Module module = chunk.findModuleBySourceFile(sourceFile);
                        if (module == null) continue;
                        File file = new File(module.getOutputDirectory());
                        if (file == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$1", "getOutputDirectory"));
                        }
                        return file;
                    }
                    throw new IllegalStateException("No module found for source files: " + sourceFiles);
                }
            };
            KotlinToJVMBytecodeCompiler.writeOutput(configuration, moduleFactory, outputDir, jarPath, jarRuntime, null);
        }
        return true;
    }

    @Nullable
    private static FqName findMainClass(@NotNull List<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "findMainClass"));
        }
        FqName mainClass = null;
        for (JetFile file : files) {
            if (!JetMainDetector.hasMain(file.getDeclarations())) continue;
            if (mainClass != null) {
                return null;
            }
            FqName fqName = JetPsiUtil.getFQName(file);
            mainClass = PackageClassUtils.getPackageClassFqName(fqName);
        }
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compileBunchOfSources(JetCoreEnvironment environment, @Nullable File jar, @Nullable File outputDir, boolean includeRuntime) {
        FqName mainClass = KotlinToJVMBytecodeCompiler.findMainClass(environment.getSourceFiles());
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment);
        if (generationState == null) {
            return false;
        }
        try {
            CompileEnvironmentUtil.OutputDirector outputDirector = CompileEnvironmentUtil.singleDirectory(outputDir);
            KotlinToJVMBytecodeCompiler.writeOutput(environment.getConfiguration(), generationState.getFactory(), outputDirector, jar, includeRuntime, mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState.destroy();
        }
    }

    public static boolean compileAndExecuteScript(@NotNull KotlinPaths paths, @NotNull JetCoreEnvironment environment, @NotNull List<String> scriptArgs) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (scriptArgs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        Class<?> scriptClass = KotlinToJVMBytecodeCompiler.compileScript(paths, environment, null);
        if (scriptClass == null) {
            return false;
        }
        try {
            scriptClass.getConstructor(String[].class).newInstance(new Object[]{scriptArgs.toArray(new String[0])});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
        return true;
    }

    private static Class<?> compileScript(@NotNull KotlinPaths paths, @NotNull JetCoreEnvironment environment, @Nullable ClassLoader parentLoader) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment);
        if (generationState == null) {
            return null;
        }
        GeneratedClassLoader classLoader = null;
        try {
            ClassFileFactory factory = generationState.getFactory();
            classLoader = new GeneratedClassLoader(factory, (ClassLoader)new URLClassLoader(new URL[]{paths.getRuntimePath().toURI().toURL()}, parentLoader == null ? AllModules.class.getClassLoader() : parentLoader), new URL[0]);
            JetFile scriptFile = environment.getSourceFiles().get(0);
            Class<?> clazz = classLoader.loadClass(ScriptNameUtil.classNameForScript(scriptFile));
            return clazz;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
        finally {
            if (classLoader != null) {
                classLoader.dispose();
            }
            generationState.destroy();
        }
    }

    @Nullable
    public static GenerationState analyzeAndGenerate(JetCoreEnvironment environment) {
        AnalyzeExhaust exhaust = KotlinToJVMBytecodeCompiler.analyze(environment);
        if (exhaust == null) {
            return null;
        }
        exhaust.throwIfError();
        return KotlinToJVMBytecodeCompiler.generate(environment, exhaust);
    }

    @Nullable
    private static AnalyzeExhaust analyze(final JetCoreEnvironment environment) {
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(environment.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY));
        analyzerWithCompilerReport.analyzeAndReport(new Function0<AnalyzeExhaust>(){

            @Override
            @NotNull
            public AnalyzeExhaust invoke() {
                BindingTrace sharedTrace = CliLightClassGenerationSupport.getInstanceForCli(environment.getProject()).getTrace();
                AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(environment.getProject(), environment.getSourceFiles(), sharedTrace, environment.getConfiguration().getList(JVMConfigurationKeys.SCRIPT_PARAMETERS), Predicates.<PsiFile>alwaysTrue(), false);
                if (analyzeExhaust == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$2", "invoke"));
                }
                return analyzeExhaust;
            }
        }, environment.getSourceFiles());
        return analyzerWithCompilerReport.hasErrors() ? null : analyzerWithCompilerReport.getAnalyzeExhaust();
    }

    @NotNull
    private static GenerationState generate(JetCoreEnvironment environment, AnalyzeExhaust exhaust) {
        Project project = environment.getProject();
        CompilerConfiguration configuration = environment.getConfiguration();
        GenerationState generationState = new GenerationState(project, ClassBuilderFactories.BINARIES, Progress.DEAF, exhaust.getBindingContext(), environment.getSourceFiles(), configuration.get(JVMConfigurationKeys.GENERATE_NOT_NULL_ASSERTIONS, false), configuration.get(JVMConfigurationKeys.GENERATE_NOT_NULL_PARAMETER_ASSERTIONS, false), true);
        KotlinCodegenFacade.compileCorrectFiles(generationState, CompilationErrorHandler.THROW_EXCEPTION);
        CompilerPluginContext context = new CompilerPluginContext(project, exhaust.getBindingContext(), environment.getSourceFiles());
        for (CompilerPlugin plugin : configuration.getList(CLIConfigurationKeys.COMPILER_PLUGINS)) {
            plugin.processFiles(context);
        }
        GenerationState generationState2 = generationState;
        if (generationState2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        return generationState2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Class compileScript(@NotNull ClassLoader parentLoader, @NotNull KotlinPaths paths, @NotNull String scriptPath, @Nullable List<AnalyzerScriptParameter> scriptParameters, @Nullable List<JetScriptDefinition> scriptDefinitions) {
        if (parentLoader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        if (scriptPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        MessageRenderer messageRenderer = MessageRenderer.PLAIN;
        GroupingMessageCollector messageCollector = new GroupingMessageCollector(new PrintingMessageCollector(System.err, messageRenderer, false));
        Disposable rootDisposable = CompileEnvironmentUtil.createMockDisposable();
        try {
            CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
            compilerConfiguration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
            compilerConfiguration.addAll(JVMConfigurationKeys.CLASSPATH_KEY, KotlinToJVMBytecodeCompiler.getClasspath(parentLoader));
            compilerConfiguration.add(JVMConfigurationKeys.CLASSPATH_KEY, PathUtil.findRtJar());
            compilerConfiguration.addAll(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, Collections.singletonList(paths.getJdkAnnotationsPath()));
            compilerConfiguration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, scriptPath);
            compilerConfiguration.addAll(CommonConfigurationKeys.SCRIPT_DEFINITIONS_KEY, scriptDefinitions != null ? scriptDefinitions : Collections.emptyList());
            compilerConfiguration.put(JVMConfigurationKeys.SCRIPT_PARAMETERS, scriptParameters);
            JetCoreEnvironment environment = new JetCoreEnvironment(rootDisposable, compilerConfiguration);
            try {
                JetScriptDefinitionProvider.getInstance(environment.getProject()).markFileAsScript(environment.getSourceFiles().get(0));
                Class<?> clazz = KotlinToJVMBytecodeCompiler.compileScript(paths, environment, parentLoader);
                return clazz;
            }
            catch (CompilationException e) {
                messageCollector.report(CompilerMessageSeverity.EXCEPTION, MessageRenderer.PLAIN.renderException(e), MessageUtil.psiElementToMessageLocation(e.getElement()));
                Class clazz = null;
                messageCollector.flush();
                Disposer.dispose(rootDisposable);
                return clazz;
            }
            catch (Throwable t) {
                MessageCollectorUtil.reportException(messageCollector, t);
                Class clazz = null;
                messageCollector.flush();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                Disposer.dispose(rootDisposable);
                return clazz;
            }
        }
        finally {
            messageCollector.flush();
            Disposer.dispose(rootDisposable);
        }
    }

    private static Collection<File> getClasspath(ClassLoader loader) {
        return KotlinToJVMBytecodeCompiler.getClasspath(loader, new LinkedList<File>());
    }

    private static Collection<File> getClasspath(ClassLoader loader, LinkedList<File> files) {
        ClassLoader parent = loader.getParent();
        if (parent != null) {
            KotlinToJVMBytecodeCompiler.getClasspath(parent, files);
        }
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                File file;
                String urlFile = url.getFile();
                if (urlFile.contains("%")) {
                    try {
                        urlFile = url.toURI().getPath();
                    }
                    catch (URISyntaxException e) {
                        throw ExceptionUtils.rethrow(e);
                    }
                }
                if (!(file = new File(urlFile)).exists() || !file.isDirectory() && !file.getName().endsWith(".jar")) continue;
                files.add(file);
            }
        }
        return files;
    }
}

