/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.Function1;
import jet.Function2;
import jet.KotlinPackageFragment;
import jet.Unit;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$groupByTo$list$9;
import kotlin.KotlinPackage$sortBy$sortBy$9;
import kotlin.KotlinPackage-IterablesSpecial-4f1cf42e;
import kotlin.KotlinPackage-Maps-e4d92eef;
import kotlin.KotlinPackage-OrderingJVM-4763a71b;
import kotlin.Pair;

@KotlinPackageFragment(abiVersion=9)
public final class KotlinPackage-_IteratorsCommon-f521d0ef {
    public static final <T> boolean all(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            if (predicate.invoke(element).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static final <T> boolean any(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            if (!predicate.invoke(element).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static final <T> int count(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        int count = 0;
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            Object object2;
            T element = iterator2.next();
            if (predicate.invoke(element).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    public static final <T> T find(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            if (!predicate.invoke(element).booleanValue()) continue;
            return element;
        }
        return null;
    }

    public static final <T, C extends Collection<? super T>> C filterTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            Object object2 = predicate.invoke(element) != false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    public static final <T, C extends Collection<? super T>> C filterNotTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            Object object2 = predicate.invoke(element) == false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    public static final <T, C extends Collection<? super T>> C filterNotNullTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") C result) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            boolean bl = true;
            if (element == null) {
                bl = false;
            }
            Object object2 = bl ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    public static final <T> Pair<List<? extends T>, List<? extends T>> partition(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        ArrayList<T> first = new ArrayList<T>();
        ArrayList<T> second = new ArrayList<T>();
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            boolean bl = predicate.invoke(element) != false ? first.add(element) : second.add(element);
        }
        return new Pair<List<? extends T>, List<? extends T>>(first, second);
    }

    public static final <T, R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="transform") Function1<? super T, ? extends R> transform) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            result.add(transform.invoke(item));
        }
        return result;
    }

    public static final <T, R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="transform") Function1<? super T, ? extends Iterable<? extends R>> transform) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            Iterable<R> list2 = transform.invoke(element);
            for (R r : list2) {
                result.add(r);
            }
        }
        return result;
    }

    public static final <T> void forEach(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="operation") Function1<? super T, ? extends Unit> operation) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            operation.invoke(element);
        }
    }

    public static final <T, R> R fold(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="initial") R initial, @JetValueParameter(name="operation") Function2<? super R, ? super T, ? extends R> operation) {
        R answer = initial;
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            answer = operation.invoke(answer, element);
        }
        return answer;
    }

    public static final <T> T reduce(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="operation") Function2<? super T, ? super T, ? extends T> operation) {
        Iterator<T> iterator2 = $receiver;
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        T result = iterator2.next();
        while (iterator2.hasNext()) {
            result = operation.invoke(result, iterator2.next());
        }
        return result;
    }

    public static final <T, K> Map<K, List<? extends T>> groupBy(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="toKey") Function1<? super T, ? extends K> toKey) {
        return KotlinPackage-_IteratorsCommon-f521d0ef.groupByTo($receiver, new HashMap(), toKey);
    }

    public static final <T, K> Map<K, List<T>> groupByTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") Map<K, List<T>> result, @JetValueParameter(name="toKey") Function1<? super T, ? extends K> toKey) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            K key = toKey.invoke(element);
            List<T> list2 = KotlinPackage-Maps-e4d92eef.getOrPut(result, key, KotlinPackage$groupByTo$list$9.instance$);
            list2.add(element);
        }
        return result;
    }

    public static final <T> List<T> drop(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="n") int n) {
        return KotlinPackage-_IteratorsCommon-f521d0ef.dropWhile($receiver, KotlinPackage-IterablesSpecial-4f1cf42e.countTo(n));
    }

    public static final <T> List<T> dropWhile(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_IteratorsCommon-f521d0ef.dropWhileTo($receiver, (List)new ArrayList(), predicate);
    }

    public static final <T, L extends List<? super T>> L dropWhileTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") L result, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        int start = 1;
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            Object object2;
            T element = iterator2.next();
            if (!(start != 0 ? predicate.invoke(element) : false)) {
                start = 0;
                object2 = result.add(element);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    public static final <T, C extends Collection<? super T>> C takeWhileTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="predicate") Function1<? super T, ? extends Boolean> predicate) {
        T element;
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext() && predicate.invoke(element = iterator2.next()).booleanValue()) {
            result.add(element);
        }
        return result;
    }

    public static final <T, C extends Collection<? super T>> C toCollection(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") C result) {
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            result.add(element);
        }
        return result;
    }

    public static final <T> List<T> reverse(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        ArrayList list2 = (ArrayList)KotlinPackage-_IteratorsCommon-f521d0ef.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list2);
        return list2;
    }

    public static final <T> LinkedList<T> toLinkedList(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return (LinkedList)KotlinPackage-_IteratorsCommon-f521d0ef.toCollection($receiver, (Collection)new LinkedList());
    }

    public static final <T> List<T> toList(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return (ArrayList)KotlinPackage-_IteratorsCommon-f521d0ef.toCollection($receiver, (Collection)new ArrayList());
    }

    public static final <T> Set<T> toSet(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return (LinkedHashSet)KotlinPackage-_IteratorsCommon-f521d0ef.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    public static final <T> SortedSet<T> toSortedSet(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return (TreeSet)KotlinPackage-_IteratorsCommon-f521d0ef.toCollection($receiver, (Collection)new TreeSet());
    }

    public static final <T> Iterator<Pair<? extends Integer, ? extends T>> withIndices(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return new IndexIterator<T>($receiver);
    }

    public static final <T, R extends Comparable<? super R>> List<T> sortBy(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="f") Function1<? super T, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage-_IteratorsCommon-f521d0ef.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage-OrderingJVM-4763a71b.comparator(new KotlinPackage$sortBy$sortBy$9(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    public static final <T> void appendString(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="buffer") Appendable buffer, @JetValueParameter(name="separator") String separator, @JetValueParameter(name="prefix") String prefix, @JetValueParameter(name="postfix") String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") String truncated) {
        buffer.append(prefix);
        int count = 0;
        Iterator<T> iterator2 = $receiver;
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (element != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : String.valueOf(element);
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static /* synthetic */ void appendString$default(Iterator iterator2, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage-_IteratorsCommon-f521d0ef.appendString(iterator2, appendable, string, string2, string3, n, string4);
    }

    public static final <T> String makeString(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="separator") String separator, @JetValueParameter(name="prefix") String prefix, @JetValueParameter(name="postfix") String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage-_IteratorsCommon-f521d0ef.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static /* synthetic */ String makeString$default(Iterator iterator2, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage-_IteratorsCommon-f521d0ef.makeString(iterator2, string, string2, string3, n, string4);
    }
}

