/*
 * Decompiled with CFR 0.152.
 */
package jline.console;

import jline.internal.Preconditions;

public class CursorBuffer {
    private boolean overTyping = false;
    public int cursor = 0;
    public final StringBuilder buffer = new StringBuilder();

    public CursorBuffer copy() {
        CursorBuffer that = new CursorBuffer();
        that.overTyping = this.overTyping;
        that.cursor = this.cursor;
        that.buffer.append(this.toString());
        return that;
    }

    public boolean isOverTyping() {
        return this.overTyping;
    }

    public void setOverTyping(boolean b) {
        this.overTyping = b;
    }

    public int length() {
        return this.buffer.length();
    }

    public char nextChar() {
        if (this.cursor == this.buffer.length()) {
            return '\u0000';
        }
        return this.buffer.charAt(this.cursor);
    }

    public char current() {
        if (this.cursor <= 0) {
            return '\u0000';
        }
        return this.buffer.charAt(this.cursor - 1);
    }

    public void write(CharSequence str2) {
        Preconditions.checkNotNull(str2);
        if (this.buffer.length() == 0) {
            this.buffer.append(str2);
        } else {
            this.buffer.insert(this.cursor, str2);
        }
        this.cursor += str2.length();
        if (this.isOverTyping() && this.cursor < this.buffer.length()) {
            this.buffer.delete(this.cursor, this.cursor + str2.length());
        }
    }

    public String toString() {
        return this.buffer.toString();
    }
}

