/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongProcedure;
import gnu.trove.TPrimitiveHash;

public abstract class TLongHash
extends TPrimitiveHash
implements TLongHashingStrategy {
    protected transient long[] _set;
    protected TLongHashingStrategy _hashingStrategy = this;

    public TLongHash() {
    }

    public TLongHash(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public Object clone() {
        TLongHash h = (TLongHash)super.clone();
        h._set = (long[])this._set.clone();
        return h;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new long[capacity];
        return capacity;
    }

    public boolean contains(long val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TLongProcedure procedure) {
        byte[] states = this._states;
        long[] set2 = this._set;
        int i = set2.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int index) {
        this._set[index] = 0L;
        super.removeAt(index);
    }

    protected int index(long val) {
        byte[] states = this._states;
        long[] set2 = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set2[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set2[index] != val));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(long val) {
        byte[] states = this._states;
        long[] set2 = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set2[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index -= probe) >= 0) continue;
            index += length;
        } while (states[index] == 1 && set2[index] != val);
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set2[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }

    @Override
    public final int computeHashCode(long val) {
        return HashFunctions.hash(val);
    }
}

