/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIntHash;
import gnu.trove.TIntProcedure;

public class TIntHashSet
extends TIntHash {
    public boolean add(int val) {
        int index = this.insertionIndex(val);
        if (index < 0) {
            return false;
        }
        byte previousState = this._states[index];
        this._set[index] = val;
        this._states[index] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            int o = oldSet[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._states[index] = 1;
        }
    }

    public int[] toArray() {
        int[] result = new int[this.size()];
        int[] set2 = this._set;
        byte[] states = this._states;
        int i = states.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            result[j++] = set2[i];
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        int[] set2 = this._set;
        byte[] states = this._states;
        int i = set2.length;
        while (i-- > 0) {
            set2[i] = 0;
            states[i] = 0;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntHashSet)) {
            return false;
        }
        final TIntHashSet that = (TIntHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TIntProcedure(){

            @Override
            public final boolean execute(int value) {
                return that.contains(value);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean addAll(int[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    private final class HashProcedure
    implements TIntProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(int key) {
            this.h += TIntHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

