/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntProcedure;
import gnu.trove.TPrimitiveHash;

public abstract class TIntHash
extends TPrimitiveHash
implements TIntHashingStrategy {
    protected transient int[] _set;
    protected TIntHashingStrategy _hashingStrategy = this;

    @Override
    public Object clone() {
        TIntHash h = (TIntHash)super.clone();
        h._set = (int[])this._set.clone();
        return h;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new int[capacity];
        return capacity;
    }

    public boolean contains(int val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] set2 = this._set;
        int i = set2.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int index) {
        this._set[index] = 0;
        super.removeAt(index);
    }

    protected int index(int val) {
        byte[] states = this._states;
        int[] set2 = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set2[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set2[index] != val));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(int val) {
        byte[] states = this._states;
        int[] set2 = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set2[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index -= probe) >= 0) continue;
            index += length;
        } while (states[index] == 1 && set2[index] != val);
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set2[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }

    @Override
    public final int computeHashCode(int val) {
        return HashFunctions.hash(val);
    }
}

