/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.util.graph.Graph;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class GraphGenerator<Node>
implements Graph<Node> {
    private final SemiGraph<Node> myGraph;
    private final Map<Node, Set<Node>> myOuts;

    public GraphGenerator(SemiGraph<Node> graph) {
        this.myGraph = graph;
        this.myOuts = new LinkedHashMap<Node, Set<Node>>();
        this.buildOuts();
    }

    private void buildOuts() {
        Collection<Node> nodes = this.myGraph.getNodes();
        for (Node node : nodes) {
            this.myOuts.put(node, new LinkedHashSet());
        }
        for (Node node : nodes) {
            Iterator<Node> inIt = this.myGraph.getIn(node);
            while (inIt.hasNext()) {
                Node inNode = inIt.next();
                Set<Node> set2 = this.myOuts.get(inNode);
                if (set2 == null) {
                    throw new AssertionError((Object)("Unexpected node " + inNode + "; nodes=" + nodes));
                }
                set2.add(node);
            }
        }
    }

    @Override
    public Collection<Node> getNodes() {
        return this.myGraph.getNodes();
    }

    @Override
    public Iterator<Node> getIn(Node n) {
        return this.myGraph.getIn(n);
    }

    @Override
    public Iterator<Node> getOut(Node n) {
        return this.myOuts.get(n).iterator();
    }

    public static interface SemiGraph<Node> {
        public Collection<Node> getNodes();

        public Iterator<Node> getIn(Node var1);
    }
}

