/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentHashMap;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentHashMap<K, MyValueReference<K, V>> myMap;
    protected final ReferenceQueue<V> myQueue = new ReferenceQueue();

    public ConcurrentRefValueHashMap() {
        this.myMap = new ConcurrentHashMap();
    }

    public ConcurrentRefValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.myMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    boolean processQueue() {
        MyValueReference ref;
        boolean processed = false;
        while ((ref = (MyValueReference)((Object)this.myQueue.poll())) != null) {
            this.myMap.remove(ref.getKey(), ref);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentRefValueHashMap", "get"));
        }
        MyValueReference<K, V> ref = this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentRefValueHashMap", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentRefValueHashMap", "put"));
        }
        this.processQueue();
        MyValueReference<K, V> oldRef = this.myMap.put(key, this.createRef(key, value));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    protected abstract MyValueReference<K, V> createRef(@NotNull K var1, @NotNull V var2);

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        V oldVal;
        block4: {
            MyValueReference<K, V> oldRef;
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentRefValueHashMap", "putIfAbsent"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentRefValueHashMap", "putIfAbsent"));
            }
            MyValueReference<K, V> newRef = this.createRef(key, value);
            do {
                this.processQueue();
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block4;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return oldVal;
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentRefValueHashMap", "remove"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentRefValueHashMap", "remove"));
        }
        this.processQueue();
        return this.myMap.remove(key, this.createRef(key, value));
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        this.processQueue();
        return this.myMap.replace(key, this.createRef(key, oldValue), this.createRef(key, newValue));
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        this.processQueue();
        MyValueReference<K, V> ref = this.myMap.replace(key, this.createRef(key, value));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyValueReference<K, V> ref = this.myMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentRefValueHashMap", "putAll"));
        }
        this.processQueue();
        for (K k : t.keySet()) {
            V v = t.get(k);
            if (v == null) continue;
            this.put(k, v);
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set<K> set2 = this.myMap.keySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueHashMap", "keySet"));
        }
        return set2;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        Collection<MyValueReference<K, V>> refs = this.myMap.values();
        for (MyValueReference<K, V> ref : refs) {
            V value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueHashMap", "values"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keys = this.keySet();
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (final K key : keys) {
            final V value = this.get(key);
            if (value == null) continue;
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException("setValue is not implemented");
                }
            });
        }
        HashSet<Map.Entry<K, V>> hashSet = entries;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueHashMap", "entrySet"));
        }
        return hashSet;
    }

    public String toString() {
        String s = "map size:" + this.size() + " [";
        for (K k : this.myMap.keySet()) {
            V v = this.get(k);
            s = s + "'" + k + "': '" + v + "', ";
        }
        s = s + "] ";
        return s;
    }

    protected static interface MyValueReference<K, V> {
        @NotNull
        public K getKey();

        public V get();
    }
}

