/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartFMap<K, V>
implements Map<K, V> {
    private static final SmartFMap EMPTY = new SmartFMap(ArrayUtil.EMPTY_OBJECT_ARRAY);
    private final Object myMap;

    private SmartFMap(Object map) {
        this.myMap = map;
    }

    public static <K, V> SmartFMap<K, V> emptyMap() {
        return EMPTY;
    }

    public SmartFMap<K, V> plus(@NotNull K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/SmartFMap", "plus"));
        }
        return new SmartFMap<K, V>(SmartFMap.doPlus(this.myMap, key, value, false));
    }

    private static Object doPlus(Object oldMap, Object key, Object value, boolean inPlace) {
        if (oldMap instanceof Map) {
            Map newMap = inPlace ? (Map)oldMap : new THashMap((Map)oldMap);
            newMap.put(key, value);
            return newMap;
        }
        Object[] array = (Object[])oldMap;
        for (int i = 0; i < array.length; i += 2) {
            Object[] newArray;
            if (!key.equals(array[i])) continue;
            Object[] objectArray = newArray = inPlace ? array : new Object[array.length];
            if (!inPlace) {
                System.arraycopy(array, 0, newArray, 0, array.length);
            }
            newArray[i + 1] = value;
            return newArray;
        }
        if (array.length == 16) {
            THashMap<Object, Object> map = new THashMap<Object, Object>();
            for (int i = 0; i < array.length; i += 2) {
                map.put(array[i], array[i + 1]);
            }
            map.put(key, value);
            return map;
        }
        Object[] newArray = new Object[array.length + 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = key;
        newArray[array.length + 1] = value;
        return newArray;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Map && ((Object)this.entrySet()).equals(((Map)obj).entrySet());
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        if (this.myMap instanceof Map) {
            return ((Map)this.myMap).containsKey(key);
        }
        Object[] array = (Object[])this.myMap;
        for (int i = 0; i < array.length; i += 2) {
            if (!key.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    @Nullable
    public V get(Object key) {
        return (V)SmartFMap.doGet(this.myMap, key);
    }

    @Nullable
    private static Object doGet(Object map, Object key) {
        if (key == null) {
            return null;
        }
        if (map instanceof Map) {
            return ((Map)map).get(key);
        }
        Object[] array = (Object[])map;
        for (int i = 0; i < array.length; i += 2) {
            if (!key.equals(array[i])) continue;
            return array[i + 1];
        }
        return null;
    }

    @Override
    @Deprecated
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet<K> result = new LinkedHashSet<K>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            result.add(entry.getKey());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            result.add(entry.getValue());
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        if (this.myMap instanceof Map) {
            return ((Map)this.myMap).size();
        }
        return ((Object[])this.myMap).length >> 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet set2 = new LinkedHashSet();
        if (this.myMap instanceof Map) {
            for (Map.Entry entry : ((Map)this.myMap).entrySet()) {
                set2.add(new AbstractMap.SimpleImmutableEntry(entry));
            }
        } else {
            Object[] array = (Object[])this.myMap;
            for (int i = 0; i < array.length; i += 2) {
                set2.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(array[i], array[i + 1]));
            }
        }
        return Collections.unmodifiableSet(set2);
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }
}

