/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.impl.source.tree.MarkersHolderFileViewProvider;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.UnsafeWeakList;
import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private static final Key<List<SmartPointerEx>> SMART_POINTERS_IN_PSI_FILE_KEY = Key.create("SMART_POINTERS_IN_PSI_FILE_KEY");
    private static final Key<Boolean> BELTS_ARE_FASTEN_KEY = Key.create("BELTS_ARE_FASTEN_KEY");
    private final Project myProject;
    private final Object lock = new Object();
    private static final Key<Reference<SmartPointerEx>> CACHED_SMART_POINTER_KEY = Key.create("CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fastenBelts(@NotNull PsiFile file, int offset, @Nullable RangeMarker[] cachedRangeMarkers) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "fastenBelts"));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (SmartPointerManagerImpl.areBeltsFastened(file)) {
                return;
            }
            file.putUserData(BELTS_ARE_FASTEN_KEY, Boolean.TRUE);
            List<SmartPointerEx> pointers = SmartPointerManagerImpl.getPointers(file);
            if (pointers == null) {
                return;
            }
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(file.getProject());
            for (int i = 0; i < pointers.size(); ++i) {
                SmartPointerEx pointer = pointers.get(i);
                if (pointer == null) continue;
                pointer.fastenBelt(offset, cachedRangeMarkers);
            }
            for (DocumentWindow injectedDoc : InjectedLanguageManager.getInstance(this.myProject).getCachedInjectedDocuments(file)) {
                PsiFile injectedFile = psiDocumentManager.getPsiFile(injectedDoc);
                if (injectedFile == null) continue;
                RangeMarker[] cachedMarkers = SmartPointerManagerImpl.getCachedRangeMarkerToInjectedFragment(injectedFile);
                this.fastenBelts(injectedFile, 0, cachedMarkers);
            }
        }
    }

    @NotNull
    private static RangeMarker[] getCachedRangeMarkerToInjectedFragment(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedRangeMarkerToInjectedFragment"));
        }
        MarkersHolderFileViewProvider provider = (MarkersHolderFileViewProvider)((Object)injectedFile.getViewProvider());
        RangeMarker[] rangeMarkerArray = provider.getCachedMarkers();
        if (rangeMarkerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedRangeMarkerToInjectedFragment"));
        }
        return rangeMarkerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfastenBelts(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "unfastenBelts"));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(file.getProject());
            file.putUserData(BELTS_ARE_FASTEN_KEY, null);
            List<SmartPointerEx> pointers = SmartPointerManagerImpl.getPointers(file);
            if (pointers == null) {
                return;
            }
            for (int i = 0; i < pointers.size(); ++i) {
                SmartPointerEx pointer = pointers.get(i);
                if (pointer == null) continue;
                pointer.unfastenBelt(offset);
            }
            for (DocumentWindow injectedDoc : InjectedLanguageManager.getInstance(this.myProject).getCachedInjectedDocuments(file)) {
                PsiFile injectedFile = psiDocumentManager.getPsiFile(injectedDoc);
                if (injectedFile == null) continue;
                this.unfastenBelts(injectedFile, 0);
            }
        }
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        SmartPointerEx<E> pointer;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            LOG.error("Invalid element:" + element);
        }
        if ((pointer = SmartPointerManagerImpl.getCachedPointer(element)) != null) {
            PsiFile psiFile = containingFile = containingFile == null ? element.getContainingFile() : containingFile;
            if (containingFile != null && SmartPointerManagerImpl.areBeltsFastened(containingFile)) {
                pointer.fastenBelt(0, null);
            }
        } else {
            pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile);
            this.initPointer(pointer, containingFile);
            element.putUserData(CACHED_SMART_POINTER_KEY, new SoftReference<SmartPointerEx<E>>(pointer));
        }
        if (pointer instanceof SmartPsiElementPointerImpl) {
            Object object2 = this.lock;
            synchronized (object2) {
                ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(1);
            }
        }
        SmartPointerEx<E> smartPointerEx = pointer;
        if (smartPointerEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPointerEx;
    }

    private static <E extends PsiElement> SmartPointerEx<E> getCachedPointer(@NotNull E element) {
        PsiElement cachedElement;
        SmartPointerEx cachedPointer;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedPointer"));
        }
        Reference<SmartPointerEx> data = element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPointerEx smartPointerEx = cachedPointer = data == null ? null : data.get();
        if (cachedPointer != null && (cachedElement = cachedPointer.getCachedElement()) != null && cachedElement != element) {
            return null;
        }
        return cachedPointer;
    }

    @Override
    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (!file.isValid()) {
            LOG.error("Invalid element:" + file);
        }
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file, ProperTextRange.create(range));
        this.initPointer(pointer, file);
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRangePointerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends PsiElement> void initPointer(@NotNull SmartPointerEx<E> pointer, PsiFile containingFile) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "initPointer"));
        }
        if (containingFile == null) {
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            List<SmartPointerEx> pointers = SmartPointerManagerImpl.getPointers(containingFile);
            if (pointers == null) {
                pointers = new UnsafeWeakList<SmartPointerEx>();
                containingFile.putUserData(SMART_POINTERS_IN_PSI_FILE_KEY, pointers);
            }
            pointers.add(pointer);
            if (SmartPointerManagerImpl.areBeltsFastened(containingFile)) {
                pointer.fastenBelt(0, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "removePointer"));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            int refCount;
            if (pointer instanceof SmartPsiElementPointerImpl && (refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1)) == 0) {
                PsiFile containingFile;
                PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
                if (element != null) {
                    element.putUserData(CACHED_SMART_POINTER_KEY, null);
                }
                if ((containingFile = pointer.getContainingFile()) == null) {
                    return false;
                }
                List<SmartPointerEx> pointers = SmartPointerManagerImpl.getPointers(containingFile);
                if (pointers == null) {
                    return false;
                }
                SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
                info.cleanup();
                return pointers.remove(pointer);
            }
        }
        return false;
    }

    private static List<SmartPointerEx> getPointers(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointers"));
        }
        return containingFile.getUserData(SMART_POINTERS_IN_PSI_FILE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPointersNumber(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointersNumber"));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            List<SmartPointerEx> pointers = SmartPointerManagerImpl.getPointers(containingFile);
            return pointers == null ? 0 : pointers.size();
        }
    }

    private static boolean areBeltsFastened(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "areBeltsFastened"));
        }
        return file.getUserData(BELTS_ARE_FASTEN_KEY) == Boolean.TRUE;
    }

    @Override
    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }
}

