/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageImpl
extends PsiPackageBase
implements Queryable,
PsiPackage {
    public static boolean DEBUG = false;
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectoriesWithLibSources;
    private volatile SoftReference<Set<String>> myPublicClassNamesCache;

    public PsiPackageImpl(PsiManager manager, String qualifiedName) {
        super(manager, qualifiedName);
    }

    @Override
    protected Collection<PsiDirectory> getAllDirectories(boolean includeLibrarySources) {
        if (includeLibrarySources) {
            if (this.myDirectoriesWithLibSources == null) {
                this.myDirectoriesWithLibSources = this.createCachedDirectories(true);
            }
            return this.myDirectoriesWithLibSources.getValue();
        }
        if (this.myDirectories == null) {
            this.myDirectories = this.createCachedDirectories(false);
        }
        return this.myDirectories.getValue();
    }

    private CachedValue<Collection<PsiDirectory>> createCachedDirectories(final boolean includeLibrarySources) {
        return CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new CachedValueProvider<Collection<PsiDirectory>>(){

            @Override
            public CachedValueProvider.Result<Collection<PsiDirectory>> compute() {
                CommonProcessors.CollectProcessor<PsiDirectory> processor = new CommonProcessors.CollectProcessor<PsiDirectory>();
                PsiPackageImpl.this.getFacade().processPackageDirectories(PsiPackageImpl.this, PsiPackageImpl.this.allScope(), processor, includeLibrarySources);
                return CachedValueProvider.Result.create(processor.getResults(), PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(PsiPackageImpl.this));
            }
        }, false);
    }

    @Override
    protected PsiElement findPackage(String qName) {
        return this.getFacade().findPackage(qName);
    }

    @Override
    public void handleQualifiedNameChange(@NotNull String newQualifiedName) {
        if (newQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "handleQualifiedNameChange"));
        }
        PsiPackageImplementationHelper.getInstance().handleQualifiedNameChange(this, newQualifiedName);
    }

    @Override
    public VirtualFile[] occursInPackagePrefixes() {
        return PsiPackageImplementationHelper.getInstance().occursInPackagePrefixes(this);
    }

    @Override
    public PsiPackageImpl getParentPackage() {
        return (PsiPackageImpl)super.getParentPackage();
    }

    @Override
    protected PsiPackageImpl createInstance(PsiManager manager, String qName) {
        return new PsiPackageImpl(this.myManager, qName);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getLanguage"));
        }
        return javaLanguage;
    }

    @Override
    public boolean isValid() {
        return PsiPackageImplementationHelper.getInstance().packagePrefixExists(this) || !this.getAllDirectories(true).isEmpty();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPackage(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getClasses(this.allScope());
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        return psiClassArray;
    }

    protected GlobalSearchScope allScope() {
        return PsiPackageImplementationHelper.getInstance().adjustAllScope(this, GlobalSearchScope.allScope(this.getProject()));
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        PsiClass[] psiClassArray = this.getFacade().getClasses(this, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new PackageAnnotationValueProvider());
        }
        return this.myAnnotationList.getValue();
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages() {
        PsiPackage[] psiPackageArray = this.getSubPackages(this.allScope());
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        PsiPackage[] psiPackageArray = this.getFacade().getSubPackages(this, scope);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance(this.myManager.getProject());
    }

    private Set<String> getClassNamesCache() {
        Set<String> cache;
        SoftReference<Set<String>> ref = this.myPublicClassNamesCache;
        Set<String> set2 = cache = ref == null ? null : (Set<String>)ref.get();
        if (cache == null) {
            GlobalSearchScope scope = this.allScope();
            if (!scope.isForceSearchingInLibrarySources()) {
                scope = new DelegatingGlobalSearchScope(scope){

                    @Override
                    public boolean isForceSearchingInLibrarySources() {
                        return true;
                    }
                };
            }
            cache = this.getFacade().getClassNames(this, scope);
            this.myPublicClassNamesCache = new SoftReference<Set<String>>(cache);
        }
        return cache;
    }

    @NotNull
    private PsiClass[] findClassesByName(String name, GlobalSearchScope scope) {
        String qName = this.getQualifiedName();
        String classQName = !qName.isEmpty() ? qName + "." + name : name;
        PsiClass[] psiClassArray = this.getFacade().findClasses(classQName, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassesByName"));
        }
        return psiClassArray;
    }

    @Override
    public boolean containsClassNamed(String name) {
        return this.getClassNamesCache().contains(name);
    }

    @Override
    @NotNull
    public PsiClass[] findClassByShortName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        if (!this.containsClassNamed(name)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = this.getFacade().findClassByShortName(name, this, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        return psiClassArray;
    }

    @Nullable
    private PsiPackage findSubPackageByName(String name) {
        String qName = this.getQualifiedName();
        String subpackageQName = qName.isEmpty() ? name : qName + "." + name;
        return this.getFacade().findPackage(subpackageQName);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        NameHint nameHint;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        GlobalSearchScope scope = place.getResolveScope();
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        JavaPsiFacadeImpl facade = this.getFacade();
        Condition<String> prefixMatcher = processor.getHint(JavaCompletionHints.NAME_FILTER);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            nameHint = processor.getHint(NameHint.KEY);
            if (nameHint != null) {
                String shortName = nameHint.getName(state);
                if (this.containsClassNamed(shortName) && this.processClassesByName(processor, state, scope, shortName)) {
                    return false;
                }
            } else if (prefixMatcher != null) {
                for (String className : this.getClassNamesCache()) {
                    if (!prefixMatcher.value(className) || !this.processClassesByName(processor, state, scope, className)) continue;
                    return false;
                }
            } else {
                PsiClass[] classes = this.getClasses(scope);
                if (!PsiPackageImpl.processClasses(processor, state, classes)) {
                    return false;
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE)) {
            nameHint = processor.getHint(NameHint.KEY);
            if (nameHint != null) {
                PsiPackage aPackage = this.findSubPackageByName(nameHint.getName(state));
                if (aPackage != null && !processor.execute(aPackage, state)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope)) {
                    String packageName = pack.getName();
                    if (packageName == null || !((JavaPsiFacade)facade).getNameHelper().isIdentifier(packageName, PsiUtil.getLanguageLevel(this)) || processor.execute(pack, state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean processClassesByName(PsiScopeProcessor processor, ResolveState state, GlobalSearchScope scope, String className) {
        PsiClass[] classes = this.findClassesByName(className, scope);
        return !PsiPackageImpl.processClasses(processor, state, classes);
    }

    private static boolean processClasses(PsiScopeProcessor processor, ResolveState state, PsiClass[] classes) {
        for (PsiClass aClass : classes) {
            if (processor.execute(aClass, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiPackageImplementationHelper.getInstance().navigate(this, requestFocus);
    }

    @Override
    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "hasModifierProperty"));
        }
        return false;
    }

    @Override
    public PsiQualifiedNamedElement getContainer() {
        return this.getParentPackage();
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        private final Object[] OOCB_DEPENDENCY = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT};

        private PackageAnnotationValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList<PsiModifierList> list2 = new ArrayList<PsiModifierList>();
            for (PsiDirectory directory : PsiPackageImpl.this.getDirectories()) {
                PsiModifierList modifierList;
                PsiPackageStatement stmt;
                PsiFile file = directory.findFile("package-info.java");
                if (file == null || (stmt = PsiTreeUtil.getChildOfType(file, PsiPackageStatement.class)) == null || (modifierList = stmt.getAnnotationList()) == null) continue;
                list2.add(modifierList);
            }
            JavaPsiFacadeImpl facade = PsiPackageImpl.this.getFacade();
            GlobalSearchScope scope = PsiPackageImpl.this.allScope();
            for (PsiClass aClass : ((JavaPsiFacade)facade).findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", scope)) {
                ContainerUtil.addIfNotNull(aClass.getModifierList(), list2);
            }
            return new CachedValueProvider.Result<PsiModifierList>(list2.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), list2), this.OOCB_DEPENDENCY);
        }
    }
}

