/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsVisitor;

public final class JsNameRef
extends JsExpressionImpl
implements HasName {
    private String ident;
    private JsName name;
    private JsExpression qualifier;

    public JsNameRef(JsName name) {
        this.name = name;
    }

    public JsNameRef(String ident) {
        this.ident = ident;
    }

    public JsNameRef(String ident, JsExpression qualifier) {
        this.ident = ident;
        this.qualifier = qualifier;
    }

    public JsNameRef(String ident, String qualifier) {
        this(ident, (JsExpression)new JsNameRef(qualifier));
    }

    public JsNameRef(JsName name, JsExpression qualifier) {
        this.name = name;
        this.qualifier = qualifier;
    }

    public String getIdent() {
        return this.name == null ? this.ident : this.name.getIdent();
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    public JsExpression getQualifier() {
        return this.qualifier;
    }

    @Override
    public boolean isLeaf() {
        return this.qualifier == null;
    }

    public void resolve(JsName name) {
        this.name = name;
        this.ident = null;
    }

    public void setQualifier(JsExpression qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitNameRef(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        if (this.qualifier != null) {
            visitor.accept(this.qualifier);
        }
    }
}

