/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.containers.Stack;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.k2js.translate.LabelGenerator;
import org.jetbrains.k2js.translate.context.AliasingContext;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.context.UsageTracker;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.expression.FunctionTranslator;
import org.jetbrains.k2js.translate.expression.InnerFunctionTranslator;
import org.jetbrains.k2js.translate.expression.InnerObjectTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public class LiteralFunctionTranslator
extends AbstractTranslator {
    private final Stack<NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>>> definitionPlaces;
    private NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>> definitionPlace;

    public LiteralFunctionTranslator(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "<init>"));
        }
        super(context);
        this.definitionPlaces = new Stack();
    }

    public static Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> createPlace(@NotNull List<JsPropertyInitializer> list, @NotNull JsExpression reference) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "createPlace"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "createPlace"));
        }
        return Trinity.create(list, new LabelGenerator('f'), reference);
    }

    public void setDefinitionPlace(@Nullable NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>> place) {
        if (place == null) {
            this.definitionPlaces.pop();
            this.definitionPlace = this.definitionPlaces.isEmpty() ? null : this.definitionPlaces.peek();
        } else {
            this.definitionPlaces.push(place);
            this.definitionPlace = place;
        }
    }

    public JsExpression translate(@NotNull JetDeclarationWithBody declaration, @NotNull FunctionDescriptor descriptor, @NotNull TranslationContext outerContext) {
        ClassDescriptor outerClass;
        boolean asInner;
        AliasingContext aliasingContext;
        JsName receiverName;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (outerContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        JsFunction fun = this.createFunction();
        DeclarationDescriptor receiverDescriptor = JsDescriptorUtils.getExpectedReceiverDescriptor(descriptor);
        if (receiverDescriptor == null) {
            receiverName = null;
            aliasingContext = null;
        } else {
            receiverName = fun.getScope().declareName(Namer.getReceiverParameterName());
            aliasingContext = outerContext.aliasingContext().inner(receiverDescriptor, receiverName.makeRef());
        }
        if (descriptor.getContainingDeclaration() instanceof ConstructorDescriptor) {
            asInner = true;
            fun.setName(fun.getScope().declareName("$fun"));
            outerClass = (ClassDescriptor)descriptor.getContainingDeclaration().getContainingDeclaration();
            assert (outerClass != null);
            if (receiverDescriptor == null) {
                aliasingContext = outerContext.aliasingContext().notShareableThisAliased(outerClass, new JsNameRef("o", (JsExpression)fun.getName().makeRef()));
            }
        } else {
            outerClass = null;
            asInner = DescriptorUtils.isTopLevelDeclaration(descriptor);
        }
        TranslationContext funContext = outerContext.newFunctionBody(fun, aliasingContext, new UsageTracker(descriptor, outerContext.usageTracker(), outerClass));
        fun.getBody().getStatements().addAll(FunctionBodyTranslator.translateFunctionBody(descriptor, declaration, funContext).getStatements());
        InnerFunctionTranslator translator = null;
        if (!asInner) {
            translator = new InnerFunctionTranslator(descriptor, funContext, fun);
        }
        if (asInner) {
            LiteralFunctionTranslator.addRegularParameters(descriptor, fun, funContext, receiverName);
            if (outerClass != null) {
                UsageTracker usageTracker = funContext.usageTracker();
                assert (usageTracker != null);
                if (usageTracker.isUsed()) {
                    return new JsInvocation(this.context().namer().kotlin("assignOwner"), fun, JsLiteral.THIS);
                }
                fun.setName(null);
            }
            return fun;
        }
        JsExpression result = translator.translate(this.createReference(fun), outerContext);
        LiteralFunctionTranslator.addRegularParameters(descriptor, fun, funContext, receiverName);
        return result;
    }

    private JsNameRef createReference(JsFunction fun) {
        Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> place = this.definitionPlace.getValue();
        JsNameRef nameRef = new JsNameRef(((LabelGenerator)place.second).generate(), (JsExpression)place.third);
        ((List)place.first).add(new JsPropertyInitializer(nameRef, fun));
        return nameRef;
    }

    private static void addRegularParameters(@NotNull FunctionDescriptor descriptor, @NotNull JsFunction fun, @NotNull TranslationContext funContext, @Nullable JsName receiverName) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "addRegularParameters"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "addRegularParameters"));
        }
        if (funContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "addRegularParameters"));
        }
        if (receiverName != null) {
            fun.getParameters().add(new JsParameter(receiverName));
        }
        FunctionTranslator.addParameters(fun.getParameters(), descriptor, funContext);
    }

    private JsFunction createFunction() {
        return new JsFunction(this.context().scope(), new JsBlock());
    }

    public JsExpression translate(@NotNull ClassDescriptor outerClass, @NotNull TranslationContext outerClassContext, @NotNull JetClassOrObject declaration, @NotNull ClassDescriptor descriptor, @NotNull ClassTranslator classTranslator) {
        if (outerClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (outerClassContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (classTranslator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        JsFunction fun = this.createFunction();
        JsNameRef outerClassRef = fun.getScope().declareName("$outer").makeRef();
        UsageTracker usageTracker = new UsageTracker(descriptor, outerClassContext.usageTracker(), outerClass);
        AliasingContext aliasingContext = outerClassContext.aliasingContext().inner(outerClass, outerClassRef);
        TranslationContext funContext = outerClassContext.newFunctionBody(fun, aliasingContext, usageTracker);
        fun.getBody().getStatements().add(new JsReturn(classTranslator.translate(funContext)));
        JetClassBody body = declaration.getBody();
        assert (body != null);
        return new InnerObjectTranslator(funContext, fun).translate(this.createReference(fun), usageTracker.isUsed() ? outerClassRef : null);
    }
}

