/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.k2js.translate.context.AliasingContext;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class FunctionTranslator
extends AbstractTranslator {
    @NotNull
    private final TranslationContext functionBodyContext;
    @NotNull
    private final JetDeclarationWithBody functionDeclaration;
    @Nullable
    private JsName extensionFunctionReceiverName;
    @NotNull
    private final JsFunction functionObject;
    @NotNull
    private final FunctionDescriptor descriptor;

    @NotNull
    public static FunctionTranslator newInstance(@NotNull JetDeclarationWithBody function, @NotNull TranslationContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "newInstance"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "newInstance"));
        }
        FunctionTranslator functionTranslator = new FunctionTranslator(function, context);
        if (functionTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "newInstance"));
        }
        return functionTranslator;
    }

    private FunctionTranslator(@NotNull JetDeclarationWithBody functionDeclaration, @NotNull TranslationContext context) {
        if (functionDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "<init>"));
        }
        super(context);
        this.descriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), functionDeclaration);
        this.functionDeclaration = functionDeclaration;
        this.functionObject = this.context().getFunctionObject(this.descriptor);
        assert (this.functionObject.getParameters().isEmpty()) : ErrorReportingUtils.message(this.bindingContext(), this.descriptor, "Function " + functionDeclaration.getText() + " processed for the second time.");
        this.functionBodyContext = this.getFunctionBodyContext();
    }

    @NotNull
    private TranslationContext getFunctionBodyContext() {
        AliasingContext aliasingContext;
        if (this.isExtensionFunction()) {
            DeclarationDescriptor expectedReceiverDescriptor = JsDescriptorUtils.getExpectedReceiverDescriptor(this.descriptor);
            assert (expectedReceiverDescriptor != null);
            this.extensionFunctionReceiverName = this.functionObject.getScope().declareName(Namer.getReceiverParameterName());
            aliasingContext = this.context().aliasingContext().inner(expectedReceiverDescriptor, this.extensionFunctionReceiverName.makeRef());
        } else {
            aliasingContext = null;
        }
        TranslationContext translationContext = this.context().newFunctionBody(this.functionObject, aliasingContext, null);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "getFunctionBodyContext"));
        }
        return translationContext;
    }

    @NotNull
    public JsPropertyInitializer translateAsEcma5PropertyDescriptor() {
        this.generateFunctionObject();
        JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(this.functionObject, this.descriptor, this.context());
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "translateAsEcma5PropertyDescriptor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public JsPropertyInitializer translateAsMethod() {
        JsName functionName = this.context().getNameForDescriptor(this.descriptor);
        this.generateFunctionObject();
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(functionName.makeRef(), this.functionObject);
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "translateAsMethod"));
        }
        return jsPropertyInitializer;
    }

    private void generateFunctionObject() {
        JsAstUtils.setParameters(this.functionObject, this.translateParameters());
        this.translateBody();
    }

    private void translateBody() {
        JetExpression jetBodyExpression = this.functionDeclaration.getBodyExpression();
        if (jetBodyExpression == null) {
            assert (this.descriptor.getModality().equals((Object)Modality.ABSTRACT));
            return;
        }
        this.functionObject.getBody().getStatements().addAll(FunctionBodyTranslator.translateFunctionBody(this.descriptor, this.functionDeclaration, this.functionBodyContext).getStatements());
    }

    @NotNull
    private List<JsParameter> translateParameters() {
        if (this.extensionFunctionReceiverName == null && this.descriptor.getValueParameters().isEmpty()) {
            List<JsParameter> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "translateParameters"));
            }
            return list;
        }
        SmartList<JsParameter> jsParameters = new SmartList<JsParameter>();
        this.mayBeAddThisParameterForExtensionFunction(jsParameters);
        FunctionTranslator.addParameters(jsParameters, this.descriptor, this.context());
        SmartList<JsParameter> smartList = jsParameters;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "translateParameters"));
        }
        return smartList;
    }

    public static void addParameters(List<JsParameter> list, FunctionDescriptor descriptor, TranslationContext context) {
        for (ValueParameterDescriptor valueParameter : descriptor.getValueParameters()) {
            list.add(new JsParameter(context.getNameForDescriptor(valueParameter)));
        }
    }

    private void mayBeAddThisParameterForExtensionFunction(@NotNull List<JsParameter> jsParameters) {
        if (jsParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/FunctionTranslator", "mayBeAddThisParameterForExtensionFunction"));
        }
        if (this.isExtensionFunction()) {
            assert (this.extensionFunctionReceiverName != null);
            jsParameters.add(new JsParameter(this.extensionFunctionReceiverName));
        }
    }

    private boolean isExtensionFunction() {
        return JsDescriptorUtils.isExtension(this.descriptor) && !(this.functionDeclaration instanceof JetFunctionLiteralExpression);
    }
}

