/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;

public final class JetScopeUtils {
    private JetScopeUtils() {
    }

    public static List<ReceiverValue> getImplicitReceiversHierarchyValues(@NotNull JetScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getImplicitReceiversHierarchyValues"));
        }
        List<ReceiverParameterDescriptor> hierarchy = scope.getImplicitReceiversHierarchy();
        return Lists.newArrayList(Collections2.transform(hierarchy, new Function<ReceiverParameterDescriptor, ReceiverValue>(){

            @Override
            public ReceiverValue apply(ReceiverParameterDescriptor receiverParameterDescriptor) {
                return receiverParameterDescriptor.getValue();
            }
        }));
    }

    public static Collection<CallableDescriptor> getAllExtensions(@NotNull JetScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "getAllExtensions"));
        }
        HashSet<CallableDescriptor> result = Sets.newHashSet();
        for (DeclarationDescriptor descriptor : scope.getAllDescriptors()) {
            CallableDescriptor callDescriptor;
            if (!(descriptor instanceof CallableDescriptor) || (callDescriptor = (CallableDescriptor)descriptor).getReceiverParameter() == null) continue;
            result.add(callDescriptor);
        }
        return result;
    }

    public static JetScope makeScopeForPropertyAccessor(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope parentScope, @NotNull DescriptorResolver descriptorResolver, @NotNull BindingTrace trace) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "makeScopeForPropertyAccessor"));
        }
        if (parentScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "makeScopeForPropertyAccessor"));
        }
        if (descriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "makeScopeForPropertyAccessor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/scopes/JetScopeUtils", "makeScopeForPropertyAccessor"));
        }
        JetScope propertyDeclarationInnerScope = descriptorResolver.getPropertyDeclarationInnerScope(propertyDescriptor, parentScope, propertyDescriptor.getTypeParameters(), propertyDescriptor.getReceiverParameter(), trace);
        WritableScopeImpl accessorScope = new WritableScopeImpl(propertyDeclarationInnerScope, parentScope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(trace), "Accessor Scope");
        accessorScope.changeLockLevel(WritableScope.LockLevel.READING);
        return accessorScope;
    }
}

