/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.AbstractScopeAdapter;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class InnerClassesScopeWrapper
extends AbstractScopeAdapter {
    private final JetScope actualScope;

    public InnerClassesScopeWrapper(JetScope actualScope) {
        this.actualScope = actualScope;
    }

    @Override
    @NotNull
    protected JetScope getWorkerScope() {
        JetScope jetScope = this.actualScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getWorkerScope"));
        }
        return jetScope;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getClassifier"));
        }
        ClassifierDescriptor classifier = this.actualScope.getClassifier(name);
        if (InnerClassesScopeWrapper.isClass(classifier)) {
            return classifier;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(LabelName labelName) {
        Collection<DeclarationDescriptor> declarationsByLabel = this.actualScope.getDeclarationsByLabel(labelName);
        Collection<DeclarationDescriptor> collection = Collections2.filter(declarationsByLabel, new Predicate<DeclarationDescriptor>(){

            @Override
            public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                return InnerClassesScopeWrapper.isClass(descriptor);
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getDeclarationsByLabel"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        Collection<DeclarationDescriptor> allDescriptors = this.actualScope.getAllDescriptors();
        Collection<DeclarationDescriptor> collection = Collections2.filter(allDescriptors, new Predicate<DeclarationDescriptor>(){

            @Override
            public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                return InnerClassesScopeWrapper.isClass(descriptor);
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getAllDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        List<ReceiverParameterDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/InnerClassesScopeWrapper", "getImplicitReceiversHierarchy"));
        }
        return list;
    }

    public String toString() {
        return "Classes from " + this.actualScope;
    }

    private static boolean isClass(DeclarationDescriptor descriptor) {
        return descriptor instanceof ClassDescriptor && !((ClassDescriptor)descriptor).getKind().isObject();
    }
}

