/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolverImpl;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameterListOwner;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaTypeParameterResolver {
    @NotNull
    private JavaTypeTransformer typeTransformer;

    public void setTypeTransformer(@NotNull JavaTypeTransformer javaTypeTransformer) {
        if (javaTypeTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeParameterResolver", "setTypeTransformer"));
        }
        this.typeTransformer = javaTypeTransformer;
    }

    @NotNull
    public Initializer resolveTypeParameters(@NotNull DeclarationDescriptor ownerDescriptor, @NotNull JavaTypeParameterListOwner typeParameterListOwner) {
        if (ownerDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeParameterResolver", "resolveTypeParameters"));
        }
        if (typeParameterListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeParameterResolver", "resolveTypeParameters"));
        }
        Initializer result = new Initializer(ownerDescriptor);
        for (JavaTypeParameter typeParameter : typeParameterListOwner.getTypeParameters()) {
            result.addTypeParameter(typeParameter);
        }
        Initializer initializer = result;
        if (initializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeParameterResolver", "resolveTypeParameters"));
        }
        return initializer;
    }

    public class Initializer {
        private final DeclarationDescriptor owner;
        private final List<TypeParameterDescriptor> descriptors;
        private final List<JavaTypeParameter> javaTypeParameters;

        private Initializer(@NotNull DeclarationDescriptor owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeParameterResolver$Initializer", "<init>"));
            }
            this.descriptors = new ArrayList<TypeParameterDescriptor>();
            this.javaTypeParameters = new ArrayList<JavaTypeParameter>();
            this.owner = owner;
        }

        private void addTypeParameter(@NotNull JavaTypeParameter typeParameter) {
            if (typeParameter == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeParameterResolver$Initializer", "addTypeParameter"));
            }
            TypeParameterDescriptorImpl descriptor = TypeParameterDescriptorImpl.createForFurtherModification(this.owner, Collections.<AnnotationDescriptor>emptyList(), false, Variance.INVARIANT, typeParameter.getName(), typeParameter.getIndex());
            this.descriptors.add(descriptor);
            this.javaTypeParameters.add(typeParameter);
        }

        @NotNull
        public List<TypeParameterDescriptor> getDescriptors() {
            List<TypeParameterDescriptor> list = this.descriptors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaTypeParameterResolver$Initializer", "getDescriptors"));
            }
            return list;
        }

        public void initialize() {
            TypeVariableResolverImpl typeVariableResolver = new TypeVariableResolverImpl(this.getDescriptors(), this.owner);
            Iterator<TypeParameterDescriptor> descriptorIterator = this.descriptors.iterator();
            Iterator<JavaTypeParameter> typeParameterIterator = this.javaTypeParameters.iterator();
            while (descriptorIterator.hasNext()) {
                TypeParameterDescriptorImpl descriptor = (TypeParameterDescriptorImpl)descriptorIterator.next();
                Collection<JavaClassifierType> upperBounds = typeParameterIterator.next().getUpperBounds();
                if (upperBounds.isEmpty()) {
                    descriptor.addUpperBound(KotlinBuiltIns.getInstance().getDefaultBound());
                } else {
                    for (JavaClassifierType upperBound : upperBounds) {
                        descriptor.addUpperBound(JavaTypeParameterResolver.this.typeTransformer.transformToType(upperBound, TypeUsage.UPPER_BOUND, typeVariableResolver));
                    }
                }
                descriptor.setInitialized();
            }
        }
    }
}

