/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationArgumentResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PostponedTasks;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationOwner;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JavaAnnotationResolver {
    public static final Name DEFAULT_ANNOTATION_MEMBER_NAME = Name.identifier("value");
    public static final FqName JETBRAINS_NOT_NULL_ANNOTATION = DescriptorResolverUtils.fqNameByClass(NotNull.class);
    public static final FqName JETBRAINS_MUTABLE_ANNOTATION = new FqName("org.jetbrains.annotations.Mutable");
    public static final FqName JETBRAINS_READONLY_ANNOTATION = new FqName("org.jetbrains.annotations.ReadOnly");
    private JavaClassResolver classResolver;
    private JavaAnnotationArgumentResolver argumentResolver;
    private ExternalAnnotationResolver externalAnnotationResolver;

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    public void setArgumentResolver(JavaAnnotationArgumentResolver argumentResolver) {
        this.argumentResolver = argumentResolver;
    }

    public void setExternalAnnotationResolver(ExternalAnnotationResolver externalAnnotationResolver) {
        this.externalAnnotationResolver = externalAnnotationResolver;
    }

    private void resolveAnnotations(@NotNull Collection<JavaAnnotation> annotations, @NotNull PostponedTasks tasks, @NotNull List<AnnotationDescriptor> result) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "resolveAnnotations"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "resolveAnnotations"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "resolveAnnotations"));
        }
        for (JavaAnnotation javaAnnotation : annotations) {
            AnnotationDescriptor annotation = this.resolveAnnotation(javaAnnotation, tasks);
            if (annotation == null) continue;
            result.add(annotation);
        }
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotations(@NotNull JavaAnnotationOwner owner, @NotNull PostponedTasks tasks) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "resolveAnnotations"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "resolveAnnotations"));
        }
        ArrayList<AnnotationDescriptor> result = new ArrayList<AnnotationDescriptor>();
        this.resolveAnnotations(owner.getAnnotations(), tasks, result);
        this.resolveAnnotations(this.externalAnnotationResolver.findExternalAnnotations(owner), tasks, result);
        ArrayList<AnnotationDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "resolveAnnotations"));
        }
        return arrayList;
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotations(@NotNull JavaAnnotationOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "resolveAnnotations"));
        }
        PostponedTasks postponedTasks = new PostponedTasks();
        List<AnnotationDescriptor> annotations = this.resolveAnnotations(owner, postponedTasks);
        postponedTasks.performTasks();
        List<AnnotationDescriptor> list = annotations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "resolveAnnotations"));
        }
        return list;
    }

    @Nullable
    public AnnotationDescriptor resolveAnnotation(@NotNull JavaAnnotation javaAnnotation, @NotNull PostponedTasks postponedTasks) {
        if (javaAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "resolveAnnotation"));
        }
        if (postponedTasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "resolveAnnotation"));
        }
        final AnnotationDescriptor annotation = new AnnotationDescriptor();
        FqName fqName = javaAnnotation.getFqName();
        if (fqName == null) {
            return null;
        }
        if (fqName.asString().startsWith("jet.runtime.typeinfo.") || fqName.equals(JETBRAINS_NOT_NULL_ANNOTATION) || fqName.equals(JvmAnnotationNames.KOTLIN_CLASS) || fqName.equals(JvmAnnotationNames.KOTLIN_PACKAGE)) {
            return null;
        }
        AnnotationDescriptor mappedClassDescriptor = JavaToKotlinClassMap.getInstance().mapToAnnotationClass(fqName);
        if (mappedClassDescriptor != null) {
            return mappedClassDescriptor;
        }
        final ClassDescriptor annotationClass = this.classResolver.resolveClass(fqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES, postponedTasks);
        if (annotationClass == null) {
            return null;
        }
        postponedTasks.addTask(new Runnable(){

            @Override
            public void run() {
                annotation.setAnnotationType(annotationClass.getDefaultType());
            }
        });
        for (JavaAnnotationArgument argument : javaAnnotation.getArguments()) {
            Name name;
            ValueParameterDescriptor descriptor;
            CompileTimeConstant<?> value = this.argumentResolver.resolveAnnotationArgument(fqName, argument, postponedTasks);
            if (value == null || (descriptor = DescriptorResolverUtils.getAnnotationParameterByName((name = argument.getName()) == null ? DEFAULT_ANNOTATION_MEMBER_NAME : name, annotationClass)) == null) continue;
            annotation.setValueArgument(descriptor, value);
        }
        return annotation;
    }

    @Nullable
    public JavaAnnotation findAnnotationWithExternal(@NotNull JavaAnnotationOwner owner, @NotNull FqName name) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "findAnnotationWithExternal"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "findAnnotationWithExternal"));
        }
        JavaAnnotation annotation = owner.findAnnotation(name);
        if (annotation != null) {
            return annotation;
        }
        return this.externalAnnotationResolver.findExternalAnnotation(owner, name);
    }

    public boolean hasNotNullAnnotation(@NotNull JavaAnnotationOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "hasNotNullAnnotation"));
        }
        return this.findAnnotationWithExternal(owner, JETBRAINS_NOT_NULL_ANNOTATION) != null;
    }

    public boolean hasMutableAnnotation(@NotNull JavaAnnotationOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "hasMutableAnnotation"));
        }
        return this.findAnnotationWithExternal(owner, JETBRAINS_MUTABLE_ANNOTATION) != null;
    }

    public boolean hasReadonlyAnnotation(@NotNull JavaAnnotationOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaAnnotationResolver", "hasReadonlyAnnotation"));
        }
        return this.findAnnotationWithExternal(owner, JETBRAINS_READONLY_ANNOTATION) != null;
    }
}

