/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.results;

import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class OverloadingConflictResolver {
    public static OverloadingConflictResolver INSTANCE = new OverloadingConflictResolver();

    private OverloadingConflictResolver() {
    }

    @Nullable
    public <D extends CallableDescriptor> ResolvedCallWithTrace<D> findMaximallySpecific(@NotNull Set<ResolvedCallWithTrace<D>> candidates, boolean discriminateGenericDescriptors) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/results/OverloadingConflictResolver", "findMaximallySpecific"));
        }
        THashSet<ResolvedCallWithTrace<D>> maximallySpecific = new THashSet<ResolvedCallWithTrace<D>>(new TObjectHashingStrategy<ResolvedCallWithTrace<D>>(){

            @Override
            public boolean equals(ResolvedCallWithTrace<D> o1, ResolvedCallWithTrace<D> o2) {
                return o1 == null ? o2 == null : o1.getResultingDescriptor().equals(o2.getResultingDescriptor());
            }

            @Override
            public int computeHashCode(ResolvedCallWithTrace<D> object) {
                return object == null ? 0 : object.getResultingDescriptor().hashCode();
            }
        });
        for (ResolvedCallWithTrace<D> candidateCall : candidates) {
            if (!this.isMaximallySpecific(candidateCall, candidates, discriminateGenericDescriptors)) continue;
            maximallySpecific.add(candidateCall);
        }
        return maximallySpecific.size() == 1 ? (ResolvedCallWithTrace)maximallySpecific.iterator().next() : null;
    }

    private <D extends CallableDescriptor> boolean isMaximallySpecific(@NotNull ResolvedCallWithTrace<D> candidateCall, @NotNull Set<ResolvedCallWithTrace<D>> candidates, boolean discriminateGenericDescriptors) {
        if (candidateCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/results/OverloadingConflictResolver", "isMaximallySpecific"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/results/OverloadingConflictResolver", "isMaximallySpecific"));
        }
        Object me = candidateCall.getResultingDescriptor();
        boolean isInvoke = candidateCall instanceof VariableAsFunctionResolvedCall;
        VariableDescriptor variable = isInvoke ? (VariableDescriptor)((VariableAsFunctionResolvedCall)candidateCall).getVariableCall().getResultingDescriptor() : null;
        for (ResolvedCallWithTrace<D> otherCall : candidates) {
            Object other = otherCall.getResultingDescriptor();
            if (other == me || !this.definitelyNotMaximallySpecific(me, other, discriminateGenericDescriptors)) continue;
            if (!isInvoke) {
                return false;
            }
            assert (otherCall instanceof VariableAsFunctionResolvedCall) : "'invoke' candidate goes with usual one: " + candidateCall + otherCall;
            ResolvedCallWithTrace<VariableDescriptor> otherVariableCall = ((VariableAsFunctionResolvedCall)otherCall).getVariableCall();
            if (!this.definitelyNotMaximallySpecific((D)variable, otherVariableCall.getResultingDescriptor(), discriminateGenericDescriptors)) continue;
            return false;
        }
        return true;
    }

    private <D extends CallableDescriptor> boolean definitelyNotMaximallySpecific(D me, D other, boolean discriminateGenericDescriptors) {
        return !this.moreSpecific(me, other, discriminateGenericDescriptors) || this.moreSpecific(other, me, discriminateGenericDescriptors);
    }

    private <Descriptor extends CallableDescriptor> boolean moreSpecific(Descriptor f, Descriptor g, boolean discriminateGenericDescriptors) {
        block21: {
            if (f.getContainingDeclaration() instanceof ScriptDescriptor && g.getContainingDeclaration() instanceof ScriptDescriptor) {
                ScriptDescriptor fs = (ScriptDescriptor)f.getContainingDeclaration();
                ScriptDescriptor gs = (ScriptDescriptor)g.getContainingDeclaration();
                if (fs.getPriority() != gs.getPriority()) {
                    return fs.getPriority() > gs.getPriority();
                }
            }
            boolean isGenericF = this.isGeneric(f);
            boolean isGenericG = this.isGeneric(g);
            if (discriminateGenericDescriptors) {
                if (!isGenericF && isGenericG) {
                    return true;
                }
                if (isGenericF && !isGenericG) {
                    return false;
                }
                if (isGenericF && isGenericG) {
                    return this.moreSpecific(DescriptorUtils.substituteBounds(f), DescriptorUtils.substituteBounds(g), false);
                }
            }
            if (OverridingUtil.overrides(f, g)) {
                return true;
            }
            if (OverridingUtil.overrides(g, f)) {
                return false;
            }
            ReceiverParameterDescriptor receiverOfF = f.getReceiverParameter();
            ReceiverParameterDescriptor receiverOfG = g.getReceiverParameter();
            if (receiverOfF != null && receiverOfG != null && !this.typeMoreSpecific(receiverOfF.getType(), receiverOfG.getType())) {
                return false;
            }
            List<ValueParameterDescriptor> fParams = f.getValueParameters();
            List<ValueParameterDescriptor> gParams = g.getValueParameters();
            int fSize = fParams.size();
            int gSize = gParams.size();
            boolean fIsVararg = this.isVariableArity(fParams);
            boolean gIsVararg = this.isVariableArity(gParams);
            if (!fIsVararg && gIsVararg) {
                return true;
            }
            if (fIsVararg && !gIsVararg) {
                return false;
            }
            if (!fIsVararg && !gIsVararg) {
                if (fSize != gSize) {
                    return false;
                }
                for (int i = 0; i < fSize; ++i) {
                    JetType gParamType;
                    ValueParameterDescriptor fParam = fParams.get(i);
                    ValueParameterDescriptor gParam = gParams.get(i);
                    JetType fParamType = fParam.getType();
                    if (this.typeMoreSpecific(fParamType, gParamType = gParam.getType())) continue;
                    return false;
                }
            }
            if (!fIsVararg || !gIsVararg) break block21;
            int minSize = Math.min(fSize, gSize);
            for (int i = 0; i < minSize - 1; ++i) {
                JetType gParamType;
                ValueParameterDescriptor fParam = fParams.get(i);
                ValueParameterDescriptor gParam = gParams.get(i);
                JetType fParamType = fParam.getType();
                if (this.typeMoreSpecific(fParamType, gParamType = gParam.getType())) continue;
                return false;
            }
            if (fSize < gSize) {
                ValueParameterDescriptor fParam = fParams.get(fSize - 1);
                JetType fParamType = fParam.getVarargElementType();
                assert (fParamType != null) : "fIsVararg guarantees this";
                for (int i = fSize - 1; i < gSize; ++i) {
                    ValueParameterDescriptor gParam = gParams.get(i);
                    if (this.typeMoreSpecific(fParamType, OverloadingConflictResolver.getVarargElementTypeOrType(gParam))) continue;
                    return false;
                }
            } else {
                ValueParameterDescriptor gParam = gParams.get(gSize - 1);
                JetType gParamType = gParam.getVarargElementType();
                assert (gParamType != null) : "gIsVararg guarantees this";
                for (int i = gSize - 1; i < fSize; ++i) {
                    ValueParameterDescriptor fParam = fParams.get(i);
                    if (this.typeMoreSpecific(OverloadingConflictResolver.getVarargElementTypeOrType(fParam), gParamType)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    private static JetType getVarargElementTypeOrType(@NotNull ValueParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/results/OverloadingConflictResolver", "getVarargElementTypeOrType"));
        }
        JetType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType != null) {
            JetType jetType = varargElementType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/OverloadingConflictResolver", "getVarargElementTypeOrType"));
            }
            return jetType;
        }
        JetType jetType = parameterDescriptor.getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/OverloadingConflictResolver", "getVarargElementTypeOrType"));
        }
        return jetType;
    }

    private boolean isVariableArity(List<ValueParameterDescriptor> fParams) {
        int fSize = fParams.size();
        return fSize > 0 && fParams.get(fSize - 1).getVarargElementType() != null;
    }

    private boolean isGeneric(CallableDescriptor f) {
        return !f.getOriginal().getTypeParameters().isEmpty();
    }

    private boolean typeMoreSpecific(@NotNull JetType specific, @NotNull JetType general) {
        if (specific == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/results/OverloadingConflictResolver", "typeMoreSpecific"));
        }
        if (general == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/results/OverloadingConflictResolver", "typeMoreSpecific"));
        }
        return JetTypeChecker.INSTANCE.isSubtypeOf(specific, general) || this.numericTypeMoreSpecific(specific, general);
    }

    private boolean numericTypeMoreSpecific(@NotNull JetType specific, @NotNull JetType general) {
        if (specific == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/results/OverloadingConflictResolver", "numericTypeMoreSpecific"));
        }
        if (general == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/results/OverloadingConflictResolver", "numericTypeMoreSpecific"));
        }
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        JetType _double = builtIns.getDoubleType();
        JetType _float = builtIns.getFloatType();
        JetType _long = builtIns.getLongType();
        JetType _int = builtIns.getIntType();
        JetType _byte = builtIns.getByteType();
        JetType _short = builtIns.getShortType();
        if (TypeUtils.equalTypes(specific, _double) && TypeUtils.equalTypes(general, _float)) {
            return true;
        }
        if (TypeUtils.equalTypes(specific, _int)) {
            if (TypeUtils.equalTypes(general, _long)) {
                return true;
            }
            if (TypeUtils.equalTypes(general, _byte)) {
                return true;
            }
            if (TypeUtils.equalTypes(general, _short)) {
                return true;
            }
        }
        return TypeUtils.equalTypes(specific, _short) && TypeUtils.equalTypes(general, _byte);
    }
}

