/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeConstraints;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class TypeConstraintsImpl
implements TypeConstraints {
    private final Variance varianceOfPosition;
    private final Set<JetType> upperBounds = Sets.newLinkedHashSet();
    private final Set<JetType> lowerBounds = Sets.newLinkedHashSet();
    private final Set<JetType> exactBounds = Sets.newLinkedHashSet();
    private Collection<JetType> resultValues;

    public TypeConstraintsImpl(Variance varianceOfPosition) {
        this.varianceOfPosition = varianceOfPosition;
    }

    @Override
    @NotNull
    public Variance getVarianceOfPosition() {
        Variance variance = this.varianceOfPosition;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeConstraintsImpl", "getVarianceOfPosition"));
        }
        return variance;
    }

    public void addBound(@NotNull BoundKind boundKind, @NotNull JetType type) {
        if (boundKind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/TypeConstraintsImpl", "addBound"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/TypeConstraintsImpl", "addBound"));
        }
        this.resultValues = null;
        switch (boundKind) {
            case LOWER_BOUND: {
                this.lowerBounds.add(type);
                break;
            }
            case UPPER_BOUND: {
                this.upperBounds.add(type);
                break;
            }
            case EXACT_BOUND: {
                this.exactBounds.add(type);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.upperBounds.isEmpty() && this.lowerBounds.isEmpty() && this.exactBounds.isEmpty();
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        Set<JetType> set = this.lowerBounds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeConstraintsImpl", "getLowerBounds"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        Set<JetType> set = this.upperBounds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeConstraintsImpl", "getUpperBounds"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<JetType> getExactBounds() {
        Set<JetType> set = this.exactBounds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeConstraintsImpl", "getExactBounds"));
        }
        return set;
    }

    TypeConstraintsImpl copy() {
        TypeConstraintsImpl typeConstraints = new TypeConstraintsImpl(this.varianceOfPosition);
        typeConstraints.upperBounds.addAll(this.upperBounds);
        typeConstraints.lowerBounds.addAll(this.lowerBounds);
        typeConstraints.exactBounds.addAll(this.exactBounds);
        typeConstraints.resultValues = this.resultValues;
        return typeConstraints;
    }

    private Collection<Pair<BoundKind, JetType>> getAllBounds() {
        ArrayList<Pair<BoundKind, JetType>> result = Lists.newArrayList();
        for (JetType exactBound : this.exactBounds) {
            result.add(Pair.create(BoundKind.EXACT_BOUND, exactBound));
        }
        for (JetType exactBound : this.upperBounds) {
            result.add(Pair.create(BoundKind.UPPER_BOUND, exactBound));
        }
        for (JetType exactBound : this.lowerBounds) {
            result.add(Pair.create(BoundKind.LOWER_BOUND, exactBound));
        }
        return result;
    }

    @Override
    @Nullable
    public JetType getValue() {
        Collection<JetType> values = this.getValues();
        if (values.size() == 1) {
            return values.iterator().next();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<JetType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<JetType> collection = this.resultValues;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeConstraintsImpl", "getValues"));
        }
        return collection;
    }

    private Collection<JetType> computeValues() {
        JetType superTypeOfAllLowerBounds;
        JetType exactBound;
        LinkedHashSet<JetType> values = Sets.newLinkedHashSet();
        if (this.isEmpty()) {
            return values;
        }
        TypeConstraints withoutErrorTypes = this.filterNotContainingErrorType(values);
        Set<JetType> exactBounds = withoutErrorTypes.getExactBounds();
        if (exactBounds.size() == 1 && this.trySuggestion(exactBound = (JetType)exactBounds.iterator().next())) {
            return Collections.singleton(exactBound);
        }
        values.addAll(exactBounds);
        Pair<Collection<JetType>, Collection<JetType>> pair = TypeUtils.filterNumberTypes(withoutErrorTypes.getLowerBounds());
        Collection<JetType> generalLowerBounds = pair.getFirst();
        Collection<JetType> numberLowerBounds = pair.getSecond();
        JetType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes(generalLowerBounds);
        if (this.trySuggestion(superTypeOfLowerBounds)) {
            return Collections.singleton(superTypeOfLowerBounds);
        }
        ContainerUtil.addIfNotNull(superTypeOfLowerBounds, values);
        Set<JetType> upperBounds = withoutErrorTypes.getUpperBounds();
        for (JetType upperBound : upperBounds) {
            if (!this.trySuggestion(upperBound)) continue;
            return Collections.singleton(upperBound);
        }
        values.addAll(withoutErrorTypes.getUpperBounds());
        JetType superTypeOfNumberLowerBounds = TypeUtils.commonSupertypeForNumberTypes(numberLowerBounds);
        if (this.trySuggestion(superTypeOfNumberLowerBounds)) {
            return Collections.singleton(superTypeOfNumberLowerBounds);
        }
        ContainerUtil.addIfNotNull(superTypeOfNumberLowerBounds, values);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.trySuggestion(superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes(Lists.newArrayList(superTypeOfLowerBounds, superTypeOfNumberLowerBounds)))) {
            return Collections.singleton(superTypeOfAllLowerBounds);
        }
        return values;
    }

    private boolean trySuggestion(@Nullable JetType suggestion) {
        if (suggestion == null) {
            return false;
        }
        if (!suggestion.getConstructor().isDenotable()) {
            return false;
        }
        if (this.getExactBounds().size() > 1) {
            return false;
        }
        for (JetType exactBound : this.getExactBounds()) {
            if (JetTypeChecker.INSTANCE.equalTypes(exactBound, suggestion)) continue;
            return false;
        }
        for (JetType lowerBound : this.getLowerBounds()) {
            if (JetTypeChecker.INSTANCE.isSubtypeOf(lowerBound, suggestion)) continue;
            return false;
        }
        for (JetType upperBound : this.getUpperBounds()) {
            if (JetTypeChecker.INSTANCE.isSubtypeOf(suggestion, upperBound)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private TypeConstraints filterNotContainingErrorType(@NotNull Collection<JetType> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/TypeConstraintsImpl", "filterNotContainingErrorType"));
        }
        TypeConstraintsImpl typeConstraintsWithoutErrorType = new TypeConstraintsImpl(this.getVarianceOfPosition());
        Collection<Pair<BoundKind, JetType>> allBounds = this.getAllBounds();
        for (Pair<BoundKind, JetType> pair : allBounds) {
            BoundKind boundKind = pair.getFirst();
            JetType type = pair.getSecond();
            if (ErrorUtils.containsErrorType(type)) {
                values.add(type);
                continue;
            }
            if (type == null) continue;
            typeConstraintsWithoutErrorType.addBound(boundKind, type);
        }
        TypeConstraintsImpl typeConstraintsImpl = typeConstraintsWithoutErrorType;
        if (typeConstraintsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeConstraintsImpl", "filterNotContainingErrorType"));
        }
        return typeConstraintsImpl;
    }

    public static enum BoundKind {
        LOWER_BOUND,
        UPPER_BOUND,
        EXACT_BOUND;

    }
}

