/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeConstraints;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class ConstraintsUtil {
    @Nullable
    public static TypeParameterDescriptor getFirstConflictingParameter(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getFirstConflictingParameter"));
        }
        for (TypeParameterDescriptor typeParameter : constraintSystem.getTypeVariables()) {
            TypeConstraints constraints = constraintSystem.getTypeConstraints(typeParameter);
            if (constraints.getValues().size() <= 1) continue;
            return typeParameter;
        }
        return null;
    }

    @NotNull
    public static Collection<TypeSubstitutor> getSubstitutorsForConflictingParameters(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSubstitutorsForConflictingParameters"));
        }
        TypeParameterDescriptor firstConflictingParameter = ConstraintsUtil.getFirstConflictingParameter(constraintSystem);
        if (firstConflictingParameter == null) {
            List<TypeSubstitutor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSubstitutorsForConflictingParameters"));
            }
            return list;
        }
        Collection<JetType> conflictingTypes = constraintSystem.getTypeConstraints(firstConflictingParameter).getValues();
        ArrayList substitutionContexts = Lists.newArrayList();
        for (JetType type : conflictingTypes) {
            LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = Maps.newLinkedHashMap();
            linkedHashMap.put(firstConflictingParameter.getTypeConstructor(), new TypeProjection(type));
            substitutionContexts.add(linkedHashMap);
        }
        for (TypeParameterDescriptor typeParameter : constraintSystem.getTypeVariables()) {
            if (typeParameter == firstConflictingParameter) continue;
            JetType jetType = ConstraintsUtil.getSafeValue(constraintSystem, typeParameter);
            for (Map map : substitutionContexts) {
                TypeProjection typeProjection = new TypeProjection(jetType);
                map.put(typeParameter.getTypeConstructor(), typeProjection);
            }
        }
        ArrayList<TypeSubstitutor> typeSubstitutors = Lists.newArrayList();
        for (Map map : substitutionContexts) {
            typeSubstitutors.add(TypeSubstitutor.create(map));
        }
        ArrayList<TypeSubstitutor> arrayList = typeSubstitutors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSubstitutorsForConflictingParameters"));
        }
        return arrayList;
    }

    @NotNull
    public static JetType getSafeValue(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
        }
        JetType type = constraintSystem.getTypeConstraints(typeParameter).getValue();
        if (type != null) {
            JetType jetType = type;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
            }
            return jetType;
        }
        JetType jetType = typeParameter.getUpperBoundsAsType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
        }
        return jetType;
    }

    public static boolean checkUpperBoundIsSatisfied(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter, boolean substituteOtherTypeParametersInBound) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "checkUpperBoundIsSatisfied"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "checkUpperBoundIsSatisfied"));
        }
        JetType type = constraintSystem.getTypeConstraints(typeParameter).getValue();
        if (type == null) {
            return true;
        }
        for (JetType upperBound : typeParameter.getUpperBounds()) {
            if (!substituteOtherTypeParametersInBound && TypeUtils.dependsOnTypeParameters(upperBound, constraintSystem.getTypeVariables())) continue;
            JetType substitutedUpperBound = constraintSystem.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            assert (substitutedUpperBound != null) : "We wanted to substitute projections as a result for " + typeParameter;
            if (JetTypeChecker.INSTANCE.isSubtypeOf(type, substitutedUpperBound)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkBoundsAreSatisfied(@NotNull ConstraintSystem constraintSystem, boolean substituteOtherTypeParametersInBounds) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "checkBoundsAreSatisfied"));
        }
        for (TypeParameterDescriptor typeVariable : constraintSystem.getTypeVariables()) {
            if (ConstraintsUtil.checkUpperBoundIsSatisfied(constraintSystem, typeVariable, substituteOtherTypeParametersInBounds)) continue;
            return false;
        }
        return true;
    }

    public static TypeSubstitutor makeConstantSubstitutor(Collection<TypeParameterDescriptor> typeParameterDescriptors, JetType type) {
        final HashSet<TypeConstructor> constructors = Sets.newHashSet();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
            constructors.add(typeParameterDescriptor.getTypeConstructor());
        }
        final TypeProjection projection = new TypeProjection(type);
        return TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                if (constructors.contains(key)) {
                    return projection;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        });
    }
}

